/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.lemmatizer;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import opennlp.tools.lemmatizer.LemmaSampleStream;
import opennlp.tools.lemmatizer.LemmatizerFactory;
import opennlp.tools.lemmatizer.LemmatizerME;
import opennlp.tools.lemmatizer.LemmatizerModel;
import opennlp.tools.util.InputStreamFactory;
import opennlp.tools.util.InsufficientTrainingDataException;
import opennlp.tools.util.MockInputStreamFactory;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.PlainTextByLineStream;
import opennlp.tools.util.TrainingParameters;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class LemmatizerMETest {
    private LemmatizerME lemmatizer;
    private static final String[] tokens = new String[]{"Rockwell", "said", "the", "agreement", "calls", "for", "it", "to", "supply", "200", "additional", "so-called", "shipsets", "for", "the", "planes", "."};
    private static final String[] postags = new String[]{"NNP", "VBD", "DT", "NN", "VBZ", "IN", "PRP", "TO", "VB", "CD", "JJ", "JJ", "NNS", "IN", "DT", "NNS", "."};
    private static final String[] expect = new String[]{"rockwell", "say", "the", "agreement", "call", "for", "it", "to", "supply", "200", "additional", "so-called", "shipset", "for", "the", "plane", "."};

    @BeforeEach
    void startup() throws IOException {
        LemmaSampleStream sampleStream = new LemmaSampleStream((ObjectStream)new PlainTextByLineStream((InputStreamFactory)new MockInputStreamFactory(new File("opennlp/tools/lemmatizer/trial.old.tsv")), StandardCharsets.UTF_8));
        TrainingParameters params = new TrainingParameters();
        params.put("Iterations", 100);
        params.put("Cutoff", 5);
        LemmatizerModel lemmatizerModel = LemmatizerME.train((String)"eng", (ObjectStream)sampleStream, (TrainingParameters)params, (LemmatizerFactory)new LemmatizerFactory());
        this.lemmatizer = new LemmatizerME(lemmatizerModel);
    }

    @Test
    void testLemmasAsArray() {
        Object[] lemmas = this.lemmatizer.lemmatize(tokens, postags);
        Assertions.assertArrayEquals((Object[])expect, (Object[])lemmas);
    }

    @Test
    void testInsufficientData() {
        Assertions.assertThrows(InsufficientTrainingDataException.class, () -> {
            LemmaSampleStream sampleStream = new LemmaSampleStream((ObjectStream)new PlainTextByLineStream((InputStreamFactory)new MockInputStreamFactory(new File("opennlp/tools/lemmatizer/trial.old-insufficient.tsv")), StandardCharsets.UTF_8));
            TrainingParameters params = new TrainingParameters();
            params.put("Iterations", 100);
            params.put("Cutoff", 5);
            LemmatizerME.train((String)"eng", (ObjectStream)sampleStream, (TrainingParameters)params, (LemmatizerFactory)new LemmatizerFactory());
        });
    }
}

