/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.lemmatizer;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import opennlp.tools.cmdline.lemmatizer.LemmaEvaluationErrorListener;
import opennlp.tools.lemmatizer.DummyLemmaSampleStream;
import opennlp.tools.lemmatizer.DummyLemmatizer;
import opennlp.tools.lemmatizer.Lemmatizer;
import opennlp.tools.lemmatizer.LemmatizerEvaluationMonitor;
import opennlp.tools.lemmatizer.LemmatizerEvaluator;
import opennlp.tools.util.InputStreamFactory;
import opennlp.tools.util.MockInputStreamFactory;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.PlainTextByLineStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class LemmatizerEvaluatorTest {
    private static final double DELTA = 1.0E-9;

    @Test
    void testEvaluator() throws IOException {
        String inPredicted = "opennlp/tools/lemmatizer/output.txt";
        String inExpected = "opennlp/tools/lemmatizer/output.txt";
        String encoding = StandardCharsets.UTF_8.name();
        DummyLemmaSampleStream predictedSample = new DummyLemmaSampleStream((ObjectStream<String>)new PlainTextByLineStream((InputStreamFactory)new MockInputStreamFactory(new File(inPredicted)), encoding), true);
        DummyLemmaSampleStream expectedSample = new DummyLemmaSampleStream((ObjectStream<String>)new PlainTextByLineStream((InputStreamFactory)new MockInputStreamFactory(new File(inExpected)), encoding), false);
        DummyLemmatizer dummyLemmatizer = new DummyLemmatizer(predictedSample);
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        LemmaEvaluationErrorListener listener = new LemmaEvaluationErrorListener((OutputStream)stream);
        LemmatizerEvaluator evaluator = new LemmatizerEvaluator((Lemmatizer)dummyLemmatizer, new LemmatizerEvaluationMonitor[]{listener});
        evaluator.evaluate((ObjectStream)expectedSample);
        Assertions.assertEquals((double)0.9877049180327869, (double)evaluator.getWordAccuracy(), (double)1.0E-9);
        Assertions.assertNotSame((Object)0, (Object)((Object)stream).toString().length());
    }
}

