/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.lemmatizer;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.StringReader;
import opennlp.tools.lemmatizer.LemmaSample;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class LemmaSampleTest {
    @Test
    void testParameterValidation() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new LemmaSample(new String[]{""}, new String[]{""}, new String[]{"test", "one element to much"}));
    }

    private static String[] createSentence() {
        return new String[]{"Forecasts", "for", "the", "trade", "figures", "range", "widely", "."};
    }

    private static String[] createTags() {
        return new String[]{"NNS", "IN", "DT", "NN", "NNS", "VBP", "RB", "."};
    }

    private static String[] createLemmas() {
        return new String[]{"Forecast", "for", "the", "trade", "figure", "range", "widely", "."};
    }

    @Test
    void testLemmaSampleSerDe() throws IOException {
        LemmaSample lemmaSample = LemmaSampleTest.createGoldSample();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(byteArrayOutputStream);
        out.writeObject(lemmaSample);
        out.flush();
        byte[] bytes = byteArrayOutputStream.toByteArray();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);
        ObjectInputStream objectInput = new ObjectInputStream(byteArrayInputStream);
        LemmaSample deSerializedLemmaSample = null;
        try {
            deSerializedLemmaSample = (LemmaSample)objectInput.readObject();
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        Assertions.assertNotNull((Object)deSerializedLemmaSample);
        Assertions.assertArrayEquals((Object[])lemmaSample.getLemmas(), (Object[])deSerializedLemmaSample.getLemmas());
        Assertions.assertArrayEquals((Object[])lemmaSample.getTokens(), (Object[])deSerializedLemmaSample.getTokens());
        Assertions.assertArrayEquals((Object[])lemmaSample.getTags(), (Object[])deSerializedLemmaSample.getTags());
    }

    @Test
    void testRetrievingContent() {
        LemmaSample sample = new LemmaSample(LemmaSampleTest.createSentence(), LemmaSampleTest.createTags(), LemmaSampleTest.createLemmas());
        Assertions.assertArrayEquals((Object[])LemmaSampleTest.createSentence(), (Object[])sample.getTokens());
        Assertions.assertArrayEquals((Object[])LemmaSampleTest.createTags(), (Object[])sample.getTags());
        Assertions.assertArrayEquals((Object[])LemmaSampleTest.createLemmas(), (Object[])sample.getLemmas());
    }

    @Test
    void testToString() throws IOException {
        LemmaSample sample = new LemmaSample(LemmaSampleTest.createSentence(), LemmaSampleTest.createTags(), LemmaSampleTest.createLemmas());
        String[] sentence = LemmaSampleTest.createSentence();
        String[] tags = LemmaSampleTest.createTags();
        String[] lemmas = LemmaSampleTest.createLemmas();
        StringReader sr = new StringReader(sample.toString());
        BufferedReader reader = new BufferedReader(sr);
        for (int i = 0; i < sentence.length; ++i) {
            String line = reader.readLine();
            String[] parts = line.split("\t");
            Assertions.assertEquals((int)3, (int)parts.length);
            Assertions.assertEquals((Object)sentence[i], (Object)parts[0]);
            Assertions.assertEquals((Object)tags[i], (Object)parts[1]);
            Assertions.assertEquals((Object)lemmas[i], (Object)parts[2]);
        }
    }

    @Test
    void testEquals() {
        Assertions.assertNotSame((Object)LemmaSampleTest.createGoldSample(), (Object)LemmaSampleTest.createGoldSample());
        Assertions.assertEquals((Object)LemmaSampleTest.createGoldSample(), (Object)LemmaSampleTest.createGoldSample());
        Assertions.assertNotEquals((Object)LemmaSampleTest.createPredSample(), (Object)LemmaSampleTest.createGoldSample());
        Assertions.assertNotEquals((Object)new Object(), (Object)LemmaSampleTest.createPredSample());
    }

    public static LemmaSample createGoldSample() {
        return new LemmaSample(LemmaSampleTest.createSentence(), LemmaSampleTest.createTags(), LemmaSampleTest.createLemmas());
    }

    public static LemmaSample createPredSample() {
        String[] lemmas = LemmaSampleTest.createLemmas();
        lemmas[5] = "figure";
        return new LemmaSample(LemmaSampleTest.createSentence(), LemmaSampleTest.createTags(), lemmas);
    }
}

