/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.lemmatizer;

import java.io.IOException;
import java.util.ArrayList;
import opennlp.tools.lemmatizer.LemmaSample;
import opennlp.tools.util.FilterObjectStream;
import opennlp.tools.util.ObjectStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DummyLemmaSampleStream
extends FilterObjectStream<String, LemmaSample> {
    private static final Logger logger = LoggerFactory.getLogger(DummyLemmaSampleStream.class);
    private final boolean mIsPredicted;
    private int count = 0;

    public DummyLemmaSampleStream(ObjectStream<String> samples, boolean isPredicted) {
        super(samples);
        this.mIsPredicted = isPredicted;
    }

    public LemmaSample read() throws IOException {
        ArrayList<String> toks = new ArrayList<String>();
        ArrayList<String> posTags = new ArrayList<String>();
        ArrayList<String> goldLemmas = new ArrayList<String>();
        ArrayList<String> predictedLemmas = new ArrayList<String>();
        String line = (String)this.samples.read();
        while (line != null && !line.isEmpty()) {
            String[] parts = line.split("\t");
            if (parts.length != 4) {
                logger.warn("Skipping corrupt line {}: {}", (Object)this.count, (Object)line);
            } else {
                toks.add(parts[0]);
                posTags.add(parts[1]);
                goldLemmas.add(parts[2]);
                predictedLemmas.add(parts[3]);
            }
            ++this.count;
            line = (String)this.samples.read();
        }
        if (!toks.isEmpty()) {
            if (this.mIsPredicted) {
                return new LemmaSample(toks.toArray(new String[0]), posTags.toArray(new String[0]), predictedLemmas.toArray(new String[0]));
            }
            return new LemmaSample(toks.toArray(new String[0]), posTags.toArray(new String[0]), goldLemmas.toArray(new String[0]));
        }
        return null;
    }
}

