/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.lemmatizer;

import opennlp.tools.lemmatizer.DictionaryLemmatizer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class DictionaryLemmatizerTest {
    private static DictionaryLemmatizer dictionaryLemmatizer;

    @BeforeAll
    static void loadDictionary() throws Exception {
        dictionaryLemmatizer = new DictionaryLemmatizer(DictionaryLemmatizerTest.class.getResourceAsStream("/opennlp/tools/lemmatizer/smalldictionary.dict"));
    }

    @Test
    void testForNullPointerException() {
        String[] sentence = new String[]{"The", "dogs", "were", "running", "and", "barking", "down", "the", "street"};
        String[] sentencePOS = new String[]{"DT", "NNS", "VBD", "VBG", "CC", "VBG", "RP", "DT", "NN"};
        String[] expectedLemma = new String[]{"the", "dog", "is", "run", "and", "bark", "down", "the", "street"};
        String[] actualLemma = dictionaryLemmatizer.lemmatize(sentence, sentencePOS);
        for (int i = 0; i < sentence.length; ++i) {
            if (actualLemma[i].equals("O")) continue;
            Assertions.assertEquals((Object)expectedLemma[i], (Object)actualLemma[i]);
        }
    }
}

