/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.lemmatizer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import opennlp.tools.lemmatizer.DictionaryLemmatizer;
import opennlp.tools.lemmatizer.DictionaryLemmatizerTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class DictionaryLemmatizerMultiTest {
    private static DictionaryLemmatizer dictionaryLemmatizer;

    @BeforeAll
    static void loadDictionary() throws Exception {
        dictionaryLemmatizer = new DictionaryLemmatizer(DictionaryLemmatizerTest.class.getResourceAsStream("/opennlp/tools/lemmatizer/smalldictionarymulti.dict"));
    }

    @Test
    void testForNullPointerException() {
        List<String> sentence = Arrays.asList("The", "dogs", "were", "running", "and", "barking", "down", "the", "street");
        List<String> sentencePOS = Arrays.asList("DT", "NNS", "VBD", "VBG", "CC", "VBG", "RP", "DT", "NN");
        ArrayList<List<String>> expectedLemmas = new ArrayList<List<String>>();
        expectedLemmas.add(List.of("the", "dog", "is", "run,run", "and", "bark, bark", "down", "the", "street"));
        List actualLemmas = dictionaryLemmatizer.lemmatize(sentence, sentencePOS);
        for (int i = 0; i < sentence.size(); ++i) {
            if (((String)((List)actualLemmas.get(0)).get(0)).equals("O")) continue;
            Assertions.assertEquals(expectedLemmas.get(i), actualLemmas.get(i));
        }
    }
}

