/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.languagemodel;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import opennlp.tools.languagemodel.LanguageModelTestUtils;
import opennlp.tools.languagemodel.NGramLanguageModel;
import opennlp.tools.ngram.NGramGenerator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class NgramLanguageModelTest {
    @Test
    public void testEmptyVocabularyProbability() {
        NGramLanguageModel model = new NGramLanguageModel();
        Assertions.assertEquals((double)0.0, (double)model.calculateProbability(new String[]{""}), (double)0.0, (String)"probability with an empty vocabulary is always 0");
        Assertions.assertEquals((double)0.0, (double)model.calculateProbability(new String[]{"1", "2", "3"}), (double)0.0, (String)"probability with an empty vocabulary is always 0");
    }

    @Test
    public void testRandomVocabularyAndSentence() {
        NGramLanguageModel model = new NGramLanguageModel();
        for (String[] sentence : LanguageModelTestUtils.generateRandomVocabulary(10)) {
            model.add(sentence);
        }
        double probability = model.calculateProbability(LanguageModelTestUtils.generateRandomSentence());
        Assertions.assertTrue((probability >= 0.0 && probability <= 1.0 ? 1 : 0) != 0, (String)("a probability measure should be between 0 and 1 [was " + probability + "]"));
    }

    @Test
    public void testNgramModel() {
        NGramLanguageModel model = new NGramLanguageModel(4);
        model.add(new String[]{"I", "saw", "the", "fox"});
        model.add(new String[]{"the", "red", "house"});
        model.add(new String[]{"I", "saw", "something", "nice"});
        double probability = model.calculateProbability(new String[]{"I", "saw", "the", "red", "house"});
        Assertions.assertTrue((probability >= 0.0 && probability <= 1.0 ? 1 : 0) != 0, (String)("a probability measure should be between 0 and 1 [was " + probability + "]"));
        Object[] tokens = model.predictNextTokens(new String[]{"I", "saw"});
        Assertions.assertNotNull((Object)tokens);
        Assertions.assertArrayEquals((Object[])new String[]{"the", "fox"}, (Object[])tokens);
    }

    @Test
    public void testBigramProbability() {
        NGramLanguageModel model = new NGramLanguageModel(2);
        model.add(new String[]{"<s>", "I", "am", "Sam", "</s>"});
        model.add(new String[]{"<s>", "Sam", "I", "am", "</s>"});
        model.add(new String[]{"<s>", "I", "do", "not", "like", "green", "eggs", "and", "ham", "</s>"});
        double probability = model.calculateProbability(new String[]{"<s>", "I"});
        Assertions.assertEquals((double)0.666, (double)probability, (double)0.001);
        probability = model.calculateProbability(new String[]{"Sam", "</s>"});
        Assertions.assertEquals((double)0.5, (double)probability, (double)0.001);
        probability = model.calculateProbability(new String[]{"<s>", "Sam"});
        Assertions.assertEquals((double)0.333, (double)probability, (double)0.001);
        probability = model.calculateProbability(new String[]{"am", "Sam"});
        Assertions.assertEquals((double)0.5, (double)probability, (double)0.001);
        probability = model.calculateProbability(new String[]{"I", "am"});
        Assertions.assertEquals((double)0.666, (double)probability, (double)0.001);
        probability = model.calculateProbability(new String[]{"I", "do"});
        Assertions.assertEquals((double)0.333, (double)probability, (double)0.001);
        probability = model.calculateProbability(new String[]{"I", "am", "Sam"});
        Assertions.assertEquals((double)0.333, (double)probability, (double)0.001);
    }

    @Test
    public void testTrigram() {
        NGramLanguageModel model = new NGramLanguageModel(3);
        model.add(new String[]{"I", "see", "the", "fox"});
        model.add(new String[]{"the", "red", "house"});
        model.add(new String[]{"I", "saw", "something", "nice"});
        double probability = model.calculateProbability(new String[]{"I", "saw", "the", "red", "house"});
        Assertions.assertTrue((probability >= 0.0 && probability <= 1.0 ? 1 : 0) != 0, (String)("a probability measure should be between 0 and 1 [was " + probability + "]"));
        Object[] tokens = model.predictNextTokens(new String[]{"I", "saw"});
        Assertions.assertNotNull((Object)tokens);
        Assertions.assertArrayEquals((Object[])new String[]{"something"}, (Object[])tokens);
    }

    @Test
    public void testBigram() {
        NGramLanguageModel model = new NGramLanguageModel(2);
        model.add(new String[]{"I", "see", "the", "fox"});
        model.add(new String[]{"the", "red", "house"});
        model.add(new String[]{"I", "saw", "something", "nice"});
        double probability = model.calculateProbability(new String[]{"I", "saw", "the", "red", "house"});
        Assertions.assertTrue((probability >= 0.0 && probability <= 1.0 ? 1 : 0) != 0, (String)("a probability measure should be between 0 and 1 [was " + probability + "]"));
        Object[] tokens = model.predictNextTokens(new String[]{"I", "saw"});
        Assertions.assertNotNull((Object)tokens);
        Assertions.assertArrayEquals((Object[])new String[]{"something"}, (Object[])tokens);
    }

    @Test
    public void testSerializedNGramLanguageModel() throws Exception {
        NGramLanguageModel languageModel = new NGramLanguageModel(this.getClass().getResourceAsStream("/opennlp/tools/ngram/ngram-model.xml"), 3);
        double probability = languageModel.calculateProbability(new String[]{"The", "brown", "fox", "jumped"});
        Assertions.assertTrue((probability >= 0.0 && probability <= 1.0 ? 1 : 0) != 0, (String)("a probability measure should be between 0 and 1 [was " + probability + "]"));
        Object[] tokens = languageModel.predictNextTokens(new String[]{"the", "brown", "fox"});
        Assertions.assertNotNull((Object)tokens);
        Assertions.assertArrayEquals((Object[])new String[]{"jumped"}, (Object[])tokens);
    }

    @Test
    public void testTrigramLanguageModelCreationFromText() throws Exception {
        int ngramSize = 3;
        NGramLanguageModel languageModel = new NGramLanguageModel(ngramSize);
        try (InputStream is = this.getClass().getResourceAsStream("/opennlp/tools/languagemodel/sentences.txt");
             BufferedReader reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));){
            for (String line : reader.lines().toList()) {
                String[] array = line.split(" ");
                List<String> split = Arrays.asList(array);
                List generatedStrings = NGramGenerator.generate(split, (int)ngramSize, (String)" ");
                for (String generatedString : generatedStrings) {
                    String[] tokens = generatedString.split(" ");
                    if (tokens.length <= 0) continue;
                    languageModel.add(tokens);
                }
            }
            Object[] tokens = languageModel.predictNextTokens(new String[]{"neural", "network", "language"});
            Assertions.assertNotNull((Object)tokens);
            Assertions.assertArrayEquals((Object[])new String[]{"models"}, (Object[])tokens);
            double p1 = languageModel.calculateProbability(new String[]{"neural", "network", "language", "models"});
            double p2 = languageModel.calculateProbability(new String[]{"neural", "network", "language", "model"});
            Assertions.assertTrue((p1 > p2 ? 1 : 0) != 0);
        }
    }
}

