/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.languagemodel;

import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Random;
import opennlp.tools.languagemodel.LanguageModel;
import opennlp.tools.ngram.NGramUtils;
import org.junit.jupiter.api.Disabled;

@Disabled
public class LanguageModelTestUtils {
    private static final MathContext CONTEXT = MathContext.DECIMAL128;
    private static final Random r = new Random();
    private static final char[] chars = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j'};

    public static Collection<String[]> generateRandomVocabulary(int size) {
        LinkedList<String[]> vocabulary = new LinkedList<String[]>();
        for (int i = 0; i < size; ++i) {
            String[] sentence = LanguageModelTestUtils.generateRandomSentence();
            vocabulary.add(sentence);
        }
        return vocabulary;
    }

    public static String[] generateRandomSentence() {
        int dimension = r.nextInt(10) + 1;
        String[] sentence = new String[dimension];
        for (int j = 0; j < dimension; ++j) {
            int i = r.nextInt(10);
            char c = chars[i];
            sentence[j] = c + "-" + c + "-" + c;
        }
        return sentence;
    }

    public static double getPerplexity(LanguageModel lm, Collection<String[]> testSet, int ngramSize) throws ArithmeticException {
        BigDecimal perplexity = new BigDecimal(1.0);
        for (String[] sentence : testSet) {
            for (String[] ngram : NGramUtils.getNGrams((String[])sentence, (int)ngramSize)) {
                double ngramProbability = lm.calculateProbability(ngram);
                perplexity = perplexity.multiply(new BigDecimal(1.0).divide(new BigDecimal(ngramProbability), CONTEXT));
            }
        }
        double p = StrictMath.log(perplexity.doubleValue());
        if (Double.isInfinite(p) || Double.isNaN(p)) {
            return Double.POSITIVE_INFINITY;
        }
        BigDecimal log = new BigDecimal(p);
        return StrictMath.pow(Math.E, log.divide(new BigDecimal(testSet.size()), CONTEXT).doubleValue());
    }
}

