/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.languagemodel;

import java.util.Collection;
import opennlp.tools.languagemodel.LanguageModel;
import opennlp.tools.languagemodel.LanguageModelTestUtils;
import opennlp.tools.languagemodel.NGramLanguageModel;
import opennlp.tools.util.StringList;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class LanguageModelEvaluationTest {
    @Test
    void testPerplexityComparison() {
        Collection<String[]> trainingVocabulary = LanguageModelTestUtils.generateRandomVocabulary(1100000);
        Collection<String[]> testVocabulary = LanguageModelTestUtils.generateRandomVocabulary(100);
        NGramLanguageModel unigramLM = new NGramLanguageModel(1);
        for (String[] sentence : trainingVocabulary) {
            unigramLM.add(new StringList(sentence), 1, 1);
        }
        double unigramPerplexity = LanguageModelTestUtils.getPerplexity((LanguageModel)unigramLM, testVocabulary, 1);
        NGramLanguageModel bigramLM = new NGramLanguageModel(2);
        for (String[] sentence : trainingVocabulary) {
            bigramLM.add(new StringList(sentence), 1, 2);
        }
        double bigramPerplexity = LanguageModelTestUtils.getPerplexity((LanguageModel)bigramLM, testVocabulary, 2);
        Assertions.assertTrue((unigramPerplexity >= bigramPerplexity ? 1 : 0) != 0);
        NGramLanguageModel trigramLM = new NGramLanguageModel(3);
        for (String[] sentence : trainingVocabulary) {
            trigramLM.add(new StringList(sentence), 1, 3);
        }
        double trigramPerplexity = LanguageModelTestUtils.getPerplexity((LanguageModel)trigramLM, testVocabulary, 3);
        Assertions.assertTrue((bigramPerplexity >= trigramPerplexity ? 1 : 0) != 0);
    }
}

