/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.langdetect;

import opennlp.tools.langdetect.Language;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class LanguageTest {
    @Test
    void emptyConfidence() {
        String languageCode = "aLanguage";
        Language lang = new Language(languageCode);
        Assertions.assertEquals((Object)languageCode, (Object)lang.getLang());
        Assertions.assertEquals((double)0.0, (double)lang.getConfidence(), (double)0.0);
    }

    @Test
    void nonEmptyConfidence() {
        String languageCode = "aLanguage";
        double confidence = 0.05;
        Language lang = new Language(languageCode, confidence);
        Assertions.assertEquals((Object)languageCode, (Object)lang.getLang());
        Assertions.assertEquals((double)confidence, (double)lang.getConfidence(), (double)0.0);
    }

    @Test
    void emptyLanguage() {
        Assertions.assertThrows(NullPointerException.class, () -> new Language(null));
    }

    @Test
    void emptyLanguageConfidence() {
        Assertions.assertThrows(NullPointerException.class, () -> new Language(null, 0.05));
    }

    @Test
    void testToString() {
        Language lang = new Language("aLang");
        Assertions.assertEquals((Object)"aLang (0.0)", (Object)lang.toString());
        lang = new Language("aLang", 0.0886678);
        Assertions.assertEquals((Object)"aLang (0.0886678)", (Object)lang.toString());
    }

    @Test
    void testHash() {
        int hashA = new Language("aLang").hashCode();
        int hashAA = new Language("aLang").hashCode();
        int hashB = new Language("BLang").hashCode();
        int hashA5 = new Language("aLang", 5.0).hashCode();
        int hashA6 = new Language("BLang", 6.0).hashCode();
        Assertions.assertEquals((int)hashA, (int)hashAA);
        Assertions.assertNotEquals((int)hashA, (int)hashB);
        Assertions.assertNotEquals((int)hashA, (int)hashA5);
        Assertions.assertNotEquals((int)hashB, (int)hashA5);
        Assertions.assertNotEquals((int)hashA5, (int)hashA6);
    }

    @Test
    void testEquals() {
        Language langA = new Language("langA");
        Language langB = new Language("langB");
        Language langA5 = new Language("langA5", 5.0);
        Language langA6 = new Language("langA5", 6.0);
        Assertions.assertEquals((Object)langA, (Object)langA);
        Assertions.assertEquals((Object)langA5, (Object)langA5);
        Assertions.assertNotEquals((Object)langA, (Object)langA5);
        Assertions.assertNotEquals((Object)langA, (Object)langB);
        Assertions.assertEquals((Object)langA6, (Object)langA5);
        Assertions.assertNotEquals((Object)"something else", (Object)langA.getLang());
    }
}

