/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.langdetect;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import opennlp.tools.langdetect.Language;
import opennlp.tools.langdetect.LanguageSample;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class LanguageSampleTest {
    @Test
    void testConstructor() {
        Language lang = new Language("aLang");
        String context = "aContext";
        LanguageSample sample = new LanguageSample(lang, (CharSequence)context);
        Assertions.assertEquals((Object)lang, (Object)sample.language());
        Assertions.assertEquals((Object)context, (Object)sample.context());
    }

    @Test
    void testLanguageSampleSerDe() throws IOException {
        Language lang = new Language("aLang");
        String context = "aContext";
        LanguageSample languageSample = new LanguageSample(lang, (CharSequence)context);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(byteArrayOutputStream);
        out.writeObject(languageSample);
        out.flush();
        byte[] bytes = byteArrayOutputStream.toByteArray();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);
        ObjectInputStream objectInput = new ObjectInputStream(byteArrayInputStream);
        LanguageSample deSerializedLanguageSample = null;
        try {
            deSerializedLanguageSample = (LanguageSample)objectInput.readObject();
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        Assertions.assertNotNull((Object)deSerializedLanguageSample);
        Assertions.assertEquals((Object)languageSample.context(), (Object)deSerializedLanguageSample.context());
        Assertions.assertEquals((Object)languageSample.language(), (Object)deSerializedLanguageSample.language());
        Assertions.assertEquals((Object)languageSample, (Object)deSerializedLanguageSample);
    }

    @Test
    void testNullLang() {
        Assertions.assertThrows(NullPointerException.class, () -> {
            String context = "aContext";
            new LanguageSample(null, (CharSequence)context);
        });
    }

    @Test
    void testNullContext() {
        Assertions.assertThrows(NullPointerException.class, () -> {
            Language lang = new Language("aLang");
            new LanguageSample(lang, null);
        });
    }

    @Test
    void testToString() {
        Language lang = new Language("aLang");
        String context = "aContext";
        LanguageSample sample = new LanguageSample(lang, (CharSequence)context);
        Assertions.assertEquals((Object)(lang.getLang() + "\t" + String.valueOf(context)), (Object)sample.toString());
    }

    @Test
    void testHash() {
        int hashA = new LanguageSample(new Language("aLang"), (CharSequence)"aContext").hashCode();
        int hashB = new LanguageSample(new Language("bLang"), (CharSequence)"aContext").hashCode();
        int hashC = new LanguageSample(new Language("aLang"), (CharSequence)"bContext").hashCode();
        Assertions.assertNotEquals((int)hashA, (int)hashB);
        Assertions.assertNotEquals((int)hashA, (int)hashC);
        Assertions.assertNotEquals((int)hashB, (int)hashC);
    }

    @Test
    void testEquals() {
        LanguageSample sampleA = new LanguageSample(new Language("aLang"), (CharSequence)"aContext");
        LanguageSample sampleA1 = new LanguageSample(new Language("aLang"), (CharSequence)"aContext");
        LanguageSample sampleB = new LanguageSample(new Language("bLang"), (CharSequence)"aContext");
        LanguageSample sampleC = new LanguageSample(new Language("aLang"), (CharSequence)"bContext");
        Assertions.assertEquals((Object)sampleA, (Object)sampleA);
        Assertions.assertEquals((Object)sampleA, (Object)sampleA1);
        Assertions.assertNotEquals((Object)sampleA, (Object)sampleB);
        Assertions.assertNotEquals((Object)sampleA, (Object)sampleC);
        Assertions.assertNotEquals((Object)sampleB, (Object)sampleC);
        Assertions.assertNotEquals((Object)"something else", (Object)sampleA.context());
    }
}

