/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.langdetect;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import opennlp.tools.formats.ResourceAsStreamFactory;
import opennlp.tools.langdetect.Language;
import opennlp.tools.langdetect.LanguageDetectorFactory;
import opennlp.tools.langdetect.LanguageDetectorME;
import opennlp.tools.langdetect.LanguageDetectorModel;
import opennlp.tools.langdetect.LanguageDetectorSampleStream;
import opennlp.tools.langdetect.ProbingLanguageDetectionResult;
import opennlp.tools.util.InputStreamFactory;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.PlainTextByLineStream;
import opennlp.tools.util.TrainingParameters;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class LanguageDetectorMETest {
    private LanguageDetectorModel model;

    @BeforeEach
    void init() throws Exception {
        this.model = LanguageDetectorMETest.trainModel();
    }

    @Test
    void testPredictLanguages() {
        LanguageDetectorME ld = new LanguageDetectorME(this.model);
        Language[] languages = ld.predictLanguages((CharSequence)"estava em uma marcenaria na Rua Bruno");
        Assertions.assertEquals((int)4, (int)languages.length);
        Assertions.assertEquals((Object)"pob", (Object)languages[0].getLang());
        Assertions.assertEquals((Object)"ita", (Object)languages[1].getLang());
        Assertions.assertEquals((Object)"spa", (Object)languages[2].getLang());
        Assertions.assertEquals((Object)"fra", (Object)languages[3].getLang());
    }

    @Test
    void testProbingPredictLanguages() {
        LanguageDetectorME ld = new LanguageDetectorME(this.model);
        for (int i = 0; i < 10000; i += 1000) {
            StringBuilder sb = new StringBuilder();
            sb.append("estava em uma marcenaria na Rua Bruno ".repeat(Math.max(0, i + 1)));
            ProbingLanguageDetectionResult result = ld.probingPredictLanguages((CharSequence)sb.toString());
            Assertions.assertTrue((result.length() <= 600 ? 1 : 0) != 0);
            Language[] languages = result.languages();
            Assertions.assertEquals((int)4, (int)languages.length);
            Assertions.assertEquals((Object)"pob", (Object)languages[0].getLang());
            Assertions.assertEquals((Object)"ita", (Object)languages[1].getLang());
            Assertions.assertEquals((Object)"spa", (Object)languages[2].getLang());
            Assertions.assertEquals((Object)"fra", (Object)languages[3].getLang());
        }
    }

    @Test
    void testPredictLanguage() {
        LanguageDetectorME ld = new LanguageDetectorME(this.model);
        Language language = ld.predictLanguage((CharSequence)"Dove \u00e8 meglio che giochi");
        Assertions.assertEquals((Object)"ita", (Object)language.getLang());
    }

    @Test
    void testSupportedLanguages() {
        LanguageDetectorME ld = new LanguageDetectorME(this.model);
        String[] supportedLanguages = ld.getSupportedLanguages();
        Assertions.assertEquals((int)4, (int)supportedLanguages.length);
    }

    @Test
    void testLoadFromSerialized() throws IOException {
        byte[] serialized = LanguageDetectorMETest.serializeModel(this.model);
        LanguageDetectorModel myModel = new LanguageDetectorModel((InputStream)new ByteArrayInputStream(serialized));
        Assertions.assertNotNull((Object)myModel);
    }

    protected static byte[] serializeModel(LanguageDetectorModel model) throws IOException {
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            model.serialize((OutputStream)out);
            byte[] byArray = out.toByteArray();
            return byArray;
        }
    }

    public static LanguageDetectorModel trainModel() throws Exception {
        return LanguageDetectorMETest.trainModel(new LanguageDetectorFactory());
    }

    public static LanguageDetectorModel trainModel(LanguageDetectorFactory factory) throws Exception {
        LanguageDetectorSampleStream sampleStream = LanguageDetectorMETest.createSampleStream();
        TrainingParameters params = new TrainingParameters();
        params.put("Iterations", 100);
        params.put("Cutoff", 5);
        params.put("DataIndexer", "TwoPass");
        params.put("Algorithm", "NAIVEBAYES");
        return LanguageDetectorME.train((ObjectStream)sampleStream, (TrainingParameters)params, (LanguageDetectorFactory)factory);
    }

    public static LanguageDetectorSampleStream createSampleStream() throws IOException {
        ResourceAsStreamFactory streamFactory = new ResourceAsStreamFactory(LanguageDetectorMETest.class, "/opennlp/tools/doccat/DoccatSample.txt");
        PlainTextByLineStream lineStream = new PlainTextByLineStream((InputStreamFactory)streamFactory, StandardCharsets.UTF_8);
        return new LanguageDetectorSampleStream((ObjectStream)lineStream);
    }
}

