/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.langdetect;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashSet;
import opennlp.tools.formats.ResourceAsStreamFactory;
import opennlp.tools.langdetect.DummyFactory;
import opennlp.tools.langdetect.LanguageDetectorContextGenerator;
import opennlp.tools.langdetect.LanguageDetectorFactory;
import opennlp.tools.langdetect.LanguageDetectorME;
import opennlp.tools.langdetect.LanguageDetectorMETest;
import opennlp.tools.langdetect.LanguageDetectorModel;
import opennlp.tools.langdetect.LanguageDetectorSampleStream;
import opennlp.tools.util.InputStreamFactory;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.PlainTextByLineStream;
import opennlp.tools.util.TrainingParameters;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class LanguageDetectorFactoryTest {
    private static LanguageDetectorModel model;
    private static byte[] serialized;

    @BeforeAll
    static void train() throws Exception {
        ResourceAsStreamFactory streamFactory = new ResourceAsStreamFactory(LanguageDetectorMETest.class, "/opennlp/tools/doccat/DoccatSample.txt");
        PlainTextByLineStream lineStream = new PlainTextByLineStream((InputStreamFactory)streamFactory, StandardCharsets.UTF_8);
        LanguageDetectorSampleStream sampleStream = new LanguageDetectorSampleStream((ObjectStream)lineStream);
        TrainingParameters params = new TrainingParameters();
        params.put("Iterations", "100");
        params.put("Cutoff", "5");
        params.put("Algorithm", "NAIVEBAYES");
        model = LanguageDetectorME.train((ObjectStream)sampleStream, (TrainingParameters)params, (LanguageDetectorFactory)new DummyFactory());
        serialized = LanguageDetectorMETest.serializeModel(model);
    }

    @Test
    void testCorrectFactory() throws IOException {
        LanguageDetectorModel myModel = new LanguageDetectorModel((InputStream)new ByteArrayInputStream(serialized));
        Assertions.assertNotNull((Object)myModel.getFactory());
        Assertions.assertInstanceOf(LanguageDetectorFactory.class, (Object)myModel.getFactory());
    }

    @Test
    void testDummyFactory() throws IOException {
        LanguageDetectorModel myModel = new LanguageDetectorModel((InputStream)new ByteArrayInputStream(serialized));
        Assertions.assertNotNull((Object)myModel.getFactory());
        Assertions.assertInstanceOf(DummyFactory.class, (Object)myModel.getFactory());
    }

    @Test
    void testDummyFactoryContextGenerator() {
        LanguageDetectorContextGenerator cg = model.getFactory().getContextGenerator();
        String[] context = (String[])cg.getContext((CharSequence)"a dummy text phrase to test if the context generator works!!!!!!!!!!!!");
        HashSet<String> set = new HashSet<String>(Arrays.asList(context));
        Assertions.assertTrue((boolean)set.contains("!!!!!"));
        Assertions.assertTrue((boolean)set.contains("a dum"));
        Assertions.assertTrue((boolean)set.contains("tg=[THE,CONTEXT,GENERATOR]"));
    }
}

