/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.langdetect;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.atomic.AtomicInteger;
import opennlp.tools.cmdline.langdetect.LanguageDetectorEvaluationErrorListener;
import opennlp.tools.langdetect.Language;
import opennlp.tools.langdetect.LanguageDetector;
import opennlp.tools.langdetect.LanguageDetectorEvaluationMonitor;
import opennlp.tools.langdetect.LanguageDetectorEvaluator;
import opennlp.tools.langdetect.LanguageDetectorME;
import opennlp.tools.langdetect.LanguageDetectorMETest;
import opennlp.tools.langdetect.LanguageDetectorModel;
import opennlp.tools.langdetect.LanguageSample;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class LanguageDetectorEvaluatorTest {
    @Test
    void processSample() throws Exception {
        LanguageDetectorModel model = LanguageDetectorMETest.trainModel();
        LanguageDetectorME langdetector = new LanguageDetectorME(model);
        final AtomicInteger correctCount = new AtomicInteger();
        final AtomicInteger incorrectCount = new AtomicInteger();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        LanguageDetectorEvaluator evaluator = new LanguageDetectorEvaluator((LanguageDetector)langdetector, new LanguageDetectorEvaluationMonitor[]{new LanguageDetectorEvaluationMonitor(){

            public void correctlyClassified(LanguageSample reference, LanguageSample prediction) {
                correctCount.incrementAndGet();
            }

            public void misclassified(LanguageSample reference, LanguageSample prediction) {
                incorrectCount.incrementAndGet();
            }
        }, new LanguageDetectorEvaluationErrorListener((OutputStream)outputStream)});
        evaluator.evaluateSample((Object)new LanguageSample(new Language("pob"), (CharSequence)"escreve e faz palestras pelo mundo inteiro sobre anjos"));
        evaluator.evaluateSample((Object)new LanguageSample(new Language("fra"), (CharSequence)"escreve e faz palestras pelo mundo inteiro sobre anjos"));
        evaluator.evaluateSample((Object)new LanguageSample(new Language("fra"), (CharSequence)"escreve e faz palestras pelo mundo inteiro sobre anjos"));
        Assertions.assertEquals((int)1, (int)correctCount.get());
        Assertions.assertEquals((int)2, (int)incorrectCount.get());
        Assertions.assertEquals((long)3L, (long)evaluator.getDocumentCount());
        Assertions.assertEquals((double)0.01, (double)evaluator.getAccuracy(), (double)0.33);
        String report = outputStream.toString(StandardCharsets.UTF_8);
        Assertions.assertEquals((Object)("Expected\tPredicted\tContext" + System.lineSeparator() + "fra\tpob\tescreve e faz palestras pelo mundo inteiro sobre anjos" + System.lineSeparator() + "fra\tpob\tescreve e faz palestras pelo mundo inteiro sobre anjos" + System.lineSeparator()), (Object)report);
    }
}

