/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.langdetect;

import java.util.concurrent.atomic.AtomicInteger;
import opennlp.tools.langdetect.LanguageDetectorCrossValidator;
import opennlp.tools.langdetect.LanguageDetectorEvaluationMonitor;
import opennlp.tools.langdetect.LanguageDetectorFactory;
import opennlp.tools.langdetect.LanguageDetectorMETest;
import opennlp.tools.langdetect.LanguageDetectorSampleStream;
import opennlp.tools.langdetect.LanguageSample;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.TrainingParameters;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class LanguageDetectorCrossValidatorTest {
    @Test
    public void evaluate() throws Exception {
        TrainingParameters params = new TrainingParameters();
        params.put("Iterations", 100);
        params.put("Cutoff", 5);
        params.put("PrintMessages", false);
        final AtomicInteger correctCount = new AtomicInteger();
        final AtomicInteger incorrectCount = new AtomicInteger();
        LanguageDetectorCrossValidator cv = new LanguageDetectorCrossValidator(params, new LanguageDetectorFactory(), new LanguageDetectorEvaluationMonitor[]{new LanguageDetectorEvaluationMonitor(){

            public void correctlyClassified(LanguageSample reference, LanguageSample prediction) {
                correctCount.incrementAndGet();
            }

            public void misclassified(LanguageSample reference, LanguageSample prediction) {
                incorrectCount.incrementAndGet();
            }
        }});
        LanguageDetectorSampleStream sampleStream = LanguageDetectorMETest.createSampleStream();
        cv.evaluate((ObjectStream)sampleStream, 2);
        Assertions.assertEquals((long)99L, (long)cv.getDocumentCount());
        Assertions.assertEquals((double)0.98989898989899, (double)cv.getDocumentAccuracy(), (double)0.01);
    }
}

