/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.langdetect;

import java.util.ArrayList;
import opennlp.tools.langdetect.DefaultLanguageDetectorContextGenerator;
import opennlp.tools.langdetect.LanguageDetectorContextGenerator;
import opennlp.tools.langdetect.LanguageDetectorFactory;
import opennlp.tools.ngram.NGramModel;
import opennlp.tools.tokenize.SimpleTokenizer;
import opennlp.tools.util.StringList;
import opennlp.tools.util.normalizer.CharSequenceNormalizer;

public class DummyFactory
extends LanguageDetectorFactory {
    public void init() {
        super.init();
    }

    public LanguageDetectorContextGenerator getContextGenerator() {
        return new MyContextGenerator(2, 5, new UpperCaseNormalizer());
    }

    private static class MyContextGenerator
    extends DefaultLanguageDetectorContextGenerator {
        private static final long serialVersionUID = 5737572653101696876L;

        public MyContextGenerator(int min, int max, CharSequenceNormalizer ... normalizers) {
            super(min, max, normalizers);
        }

        public <T extends CharSequence> T[] getContext(CharSequence document) {
            CharSequence[] superContext = super.getContext(document);
            ArrayList<Object> context = new ArrayList<Object>(superContext.length);
            for (CharSequence cs : superContext) {
                context.add(cs.toString());
            }
            document = this.normalizer.normalize(document);
            SimpleTokenizer tokenizer = SimpleTokenizer.INSTANCE;
            String[] words = tokenizer.tokenize(document.toString());
            NGramModel tokenNgramModel = new NGramModel();
            if (words.length > 0) {
                tokenNgramModel.add(new StringList(words), 1, 3);
                for (StringList tokenList : tokenNgramModel) {
                    if (tokenList.size() <= 0) continue;
                    context.add("tg=" + String.valueOf(tokenList));
                }
            }
            return context.toArray(new String[0]);
        }
    }

    private static class UpperCaseNormalizer
    implements CharSequenceNormalizer {
        private static final long serialVersionUID = 589425364183582853L;

        private UpperCaseNormalizer() {
        }

        public CharSequence normalize(CharSequence text) {
            return text.toString().toUpperCase();
        }
    }
}

