/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats.ontonotes;

import java.io.IOException;
import opennlp.tools.cmdline.ObjectStreamFactory;
import opennlp.tools.cmdline.StreamFactoryRegistry;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.formats.AbstractSampleStreamFactory;
import opennlp.tools.formats.AbstractSampleStreamFactoryTest;
import opennlp.tools.formats.ontonotes.OntoNotesFormatParameters;
import opennlp.tools.formats.ontonotes.OntoNotesParseSampleStreamFactory;
import opennlp.tools.parser.Parse;
import opennlp.tools.util.ObjectStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class OntoNotesParseSampleStreamFactoryTest
extends AbstractSampleStreamFactoryTest<Parse, OntoNotesFormatParameters> {
    private static final String REFERENCE = "*PRO* Judging from the Americana in Haruki Murakami 's `` A Wild Sheep Chase '' ( Kodansha , 320 pages , $ 18.95 *U* ) , baby boomers on both sides of the Pacific have a lot in common . ";
    private OntoNotesParseSampleStreamFactory factory;
    private String sampleFileFullPath;

    @Override
    protected AbstractSampleStreamFactory<Parse, OntoNotesFormatParameters> getFactory() {
        return this.factory;
    }

    @Override
    protected String getDataFilePath() {
        return this.sampleFileFullPath;
    }

    @BeforeAll
    static void initEnv() {
        OntoNotesParseSampleStreamFactory.registerFactory();
    }

    @BeforeEach
    void setUp() {
        ObjectStreamFactory f = StreamFactoryRegistry.getFactory(Parse.class, (String)"ontonotes");
        Assertions.assertInstanceOf(OntoNotesParseSampleStreamFactory.class, (Object)f);
        this.factory = (OntoNotesParseSampleStreamFactory)f;
        Assertions.assertEquals(OntoNotesFormatParameters.class, (Object)this.factory.getParameters());
        this.sampleFileFullPath = this.getResourceWithoutPrefix("opennlp/tools/formats/ontonotes").getPath();
    }

    @Test
    void testCreateWithValidParameter() throws IOException {
        try (ObjectStream stream = this.factory.create(new String[]{"-ontoNotesDir", this.sampleFileFullPath});){
            Parse sample = (Parse)stream.read();
            Assertions.assertNotNull((Object)sample);
            Assertions.assertEquals((Object)REFERENCE, (Object)sample.getText());
        }
    }

    @Override
    @Test
    protected void testCreateWithInvalidDataFilePath() {
        Assertions.assertThrows(TerminateToolException.class, () -> {
            try (ObjectStream stream = this.factory.create(new String[]{"-ontoNotesDir", this.sampleFileFullPath + "xyz"});){
                Parse sample = (Parse)stream.read();
                Assertions.assertNotNull((Object)sample);
            }
        });
    }
}

