/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats.ontonotes;

import java.io.IOException;
import opennlp.tools.cmdline.ObjectStreamFactory;
import opennlp.tools.cmdline.StreamFactoryRegistry;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.formats.AbstractSampleStreamFactory;
import opennlp.tools.formats.AbstractSampleStreamFactoryTest;
import opennlp.tools.formats.ontonotes.OntoNotesFormatParameters;
import opennlp.tools.formats.ontonotes.OntoNotesNameSampleStreamFactory;
import opennlp.tools.namefind.NameSample;
import opennlp.tools.util.ObjectStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class OntoNotesNameSampleStreamFactoryTest
extends AbstractSampleStreamFactoryTest<NameSample, OntoNotesFormatParameters> {
    private OntoNotesNameSampleStreamFactory factory;
    private String sampleFileFullPath;

    @Override
    protected AbstractSampleStreamFactory<NameSample, OntoNotesFormatParameters> getFactory() {
        return this.factory;
    }

    @Override
    protected String getDataFilePath() {
        return this.sampleFileFullPath;
    }

    @BeforeAll
    static void initEnv() {
        OntoNotesNameSampleStreamFactory.registerFactory();
    }

    @BeforeEach
    void setUp() {
        ObjectStreamFactory f = StreamFactoryRegistry.getFactory(NameSample.class, (String)"ontonotes");
        Assertions.assertInstanceOf(OntoNotesNameSampleStreamFactory.class, (Object)f);
        this.factory = (OntoNotesNameSampleStreamFactory)f;
        Assertions.assertEquals(OntoNotesFormatParameters.class, (Object)this.factory.getParameters());
        this.sampleFileFullPath = this.getResourceWithoutPrefix("opennlp/tools/formats/ontonotes").getPath();
    }

    @Test
    void testCreateWithValidParameter() throws IOException {
        try (ObjectStream stream = this.factory.create(new String[]{"-ontoNotesDir", this.sampleFileFullPath});){
            NameSample sample = (NameSample)stream.read();
            Assertions.assertNotNull((Object)sample);
        }
    }

    @Override
    @Test
    protected void testCreateWithInvalidDataFilePath() {
        Assertions.assertThrows(TerminateToolException.class, () -> {
            try (ObjectStream stream = this.factory.create(new String[]{"-ontoNotesDir", this.sampleFileFullPath + "xyz"});){
                NameSample sample = (NameSample)stream.read();
                Assertions.assertNotNull((Object)sample);
            }
        });
    }
}

