/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats.nkjp;

import java.io.InputStream;
import java.util.Map;
import opennlp.tools.formats.AbstractFormatTest;
import opennlp.tools.formats.nkjp.NKJPTextDocument;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class NKJPTextDocumentTest
extends AbstractFormatTest {
    @Test
    void testParsingSimpleDoc() throws Exception {
        try (InputStream nkjpTextXmlIn = this.getResourceStream("nkjp/text_structure.xml");){
            NKJPTextDocument doc = NKJPTextDocument.parse((InputStream)nkjpTextXmlIn);
            Assertions.assertEquals((int)1, (int)doc.getDivtypes().size());
            Assertions.assertEquals((Object)"article", doc.getDivtypes().get("div-1"));
            Assertions.assertEquals((int)1, (int)doc.getTexts().size());
            Assertions.assertEquals((int)1, (int)((Map)doc.getTexts().get("text-1")).size());
            Assertions.assertEquals((int)2, (int)((Map)((Map)doc.getTexts().get("text-1")).get("div-1")).size());
            String exp = "To kr\u00f3tki tekst w formacie NKJP. Zawiera dwa zdania.";
            Assertions.assertEquals((Object)exp, ((Map)((Map)doc.getTexts().get("text-1")).get("div-1")).get("p-1"));
        }
    }

    @Test
    void testGetParagraphs() throws Exception {
        try (InputStream nkjpTextXmlIn = this.getResourceStream("nkjp/text_structure.xml");){
            NKJPTextDocument doc = NKJPTextDocument.parse((InputStream)nkjpTextXmlIn);
            Map paras = doc.getParagraphs();
            Assertions.assertEquals((Object)"To kr\u00f3tkie zdanie w drugim akapicie.", paras.get("ab-1"));
        }
    }
}

