/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats.nkjp;

import java.io.IOException;
import opennlp.tools.cmdline.ObjectStreamFactory;
import opennlp.tools.cmdline.StreamFactoryRegistry;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.formats.AbstractSampleStreamFactory;
import opennlp.tools.formats.AbstractSampleStreamFactoryTest;
import opennlp.tools.formats.nkjp.NKJPSentenceSampleStreamFactory;
import opennlp.tools.sentdetect.SentenceSample;
import opennlp.tools.util.ObjectStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class NKJPSentenceSampleStreamFactoryTest
extends AbstractSampleStreamFactoryTest<SentenceSample, NKJPSentenceSampleStreamFactory.Parameters> {
    private static final String SAMPLE_01 = "ann_segmentation.xml";
    private static final String TEXT_01 = "text_structure.xml";
    private NKJPSentenceSampleStreamFactory factory;
    private String sampleFileFullPath;
    private String textFileFullPath;

    @Override
    protected AbstractSampleStreamFactory<SentenceSample, NKJPSentenceSampleStreamFactory.Parameters> getFactory() {
        return this.factory;
    }

    @Override
    protected String getDataFilePath() {
        return this.sampleFileFullPath;
    }

    @BeforeAll
    static void initEnv() {
        NKJPSentenceSampleStreamFactory.registerFactory();
    }

    @BeforeEach
    void setUp() {
        ObjectStreamFactory f = StreamFactoryRegistry.getFactory(SentenceSample.class, (String)"nkjp");
        Assertions.assertInstanceOf(NKJPSentenceSampleStreamFactory.class, (Object)f);
        this.factory = (NKJPSentenceSampleStreamFactory)f;
        Assertions.assertEquals(NKJPSentenceSampleStreamFactory.Parameters.class, (Object)this.factory.getParameters());
        this.sampleFileFullPath = this.getResourceWithoutPrefix("opennlp/tools/formats/nkjp/ann_segmentation.xml").getPath();
        this.textFileFullPath = this.getResourceWithoutPrefix("opennlp/tools/formats/nkjp/text_structure.xml").getPath();
    }

    @Test
    void testCreateWithValidParameter() throws IOException {
        try (ObjectStream stream = this.factory.create(new String[]{"-textFile", this.textFileFullPath, "-data", this.sampleFileFullPath});){
            SentenceSample sample = (SentenceSample)stream.read();
            Assertions.assertNotNull((Object)sample);
        }
    }

    @Override
    @Test
    protected void testCreateWithInvalidDataFilePath() {
        Assertions.assertThrows(TerminateToolException.class, () -> {
            try (ObjectStream stream = this.getFactory().create(new String[]{"-textFile", this.textFileFullPath, "-data", this.getDataFilePath() + "xyz"});){
                SentenceSample sample = (SentenceSample)stream.read();
                Assertions.assertNotNull((Object)sample);
            }
        });
    }
}

