/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats.nkjp;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import opennlp.tools.formats.AbstractFormatTest;
import opennlp.tools.formats.nkjp.NKJPSegmentationDocument;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class NKJPSegmentationDocumentTest
extends AbstractFormatTest {
    @Test
    void testParsingSimpleDoc() throws IOException {
        try (InputStream nkjpSegXmlIn = this.getResourceStream("nkjp/ann_segmentation.xml");){
            NKJPSegmentationDocument doc = NKJPSegmentationDocument.parse((InputStream)nkjpSegXmlIn);
            Assertions.assertEquals((int)1, (int)doc.getSegments().size());
            Assertions.assertEquals((int)7, (int)((Map)doc.getSegments().get("segm_1.1-s")).size());
            String src = "To kr\u00f3tkie zdanie w drugim akapicie.";
            int offset = ((NKJPSegmentationDocument.Pointer)((Map)doc.getSegments().get((Object)"segm_1.1-s")).get((Object)"segm_1.1-seg")).offset;
            Assertions.assertEquals((int)0, (int)offset);
            int length = ((NKJPSegmentationDocument.Pointer)((Map)doc.getSegments().get((Object)"segm_1.1-s")).get((Object)"segm_1.1-seg")).length;
            Assertions.assertEquals((int)2, (int)length);
            Assertions.assertEquals((Object)"To", (Object)src.substring(offset, length));
        }
    }
}

