/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats.muc;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import opennlp.tools.cmdline.ObjectStreamFactory;
import opennlp.tools.cmdline.StreamFactoryRegistry;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.formats.AbstractSampleStreamFactory;
import opennlp.tools.formats.AbstractSampleStreamFactoryTest;
import opennlp.tools.formats.muc.Muc6NameSampleStreamFactory;
import opennlp.tools.models.ModelType;
import opennlp.tools.namefind.NameSample;
import opennlp.tools.tokenize.TokenizerModel;
import opennlp.tools.util.DownloadUtil;
import opennlp.tools.util.ObjectStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Muc6NameSampleStreamFactoryTest
extends AbstractSampleStreamFactoryTest<NameSample, Muc6NameSampleStreamFactory.Parameters> {
    private static final Path OPENNLP_DIR = Paths.get(System.getProperty("OPENNLP_DOWNLOAD_HOME", System.getProperty("user.home")), new String[0]).resolve(".opennlp");
    private static final String TOKENIZER_MODEL_NAME = "opennlp-en-ud-ewt-tokens-1.3-2.5.4.bin";
    private Muc6NameSampleStreamFactory factory;
    private static String tokenizerFileFullPath;
    private String sampleFileFullPath;

    @Override
    protected AbstractSampleStreamFactory<NameSample, Muc6NameSampleStreamFactory.Parameters> getFactory() {
        return this.factory;
    }

    @Override
    protected String getDataFilePath() {
        return this.sampleFileFullPath;
    }

    @BeforeAll
    static void initEnv() {
        Muc6NameSampleStreamFactory.registerFactory();
        try {
            DownloadUtil.downloadModel((String)"en", (ModelType)ModelType.TOKENIZER, TokenizerModel.class);
        }
        catch (IOException e) {
            Assertions.fail((String)e.getLocalizedMessage());
        }
        tokenizerFileFullPath = new File(String.valueOf(OPENNLP_DIR) + File.separator + TOKENIZER_MODEL_NAME).getPath();
    }

    @BeforeEach
    void setUp() {
        ObjectStreamFactory f = StreamFactoryRegistry.getFactory(NameSample.class, (String)"muc6");
        Assertions.assertInstanceOf(Muc6NameSampleStreamFactory.class, (Object)f);
        this.factory = (Muc6NameSampleStreamFactory)f;
        Assertions.assertEquals(Muc6NameSampleStreamFactory.Parameters.class, (Object)this.factory.getParameters());
        this.sampleFileFullPath = this.getResourceWithoutPrefix("opennlp/tools/formats/muc").getPath();
    }

    @Test
    void testCreateWithValidParameter() throws IOException {
        try (ObjectStream stream = this.factory.create(new String[]{"-tokenizerModel", tokenizerFileFullPath, "-data", this.sampleFileFullPath + File.separator});){
            NameSample sample = (NameSample)stream.read();
            Assertions.assertNotNull((Object)sample);
        }
    }

    @Override
    @Test
    protected void testCreateWithInvalidDataFilePath() {
        Assertions.assertThrows(TerminateToolException.class, () -> {
            try (ObjectStream stream = this.factory.create(new String[]{"-tokenizerModel", tokenizerFileFullPath, "-data", this.sampleFileFullPath + "xyz" + File.separator});){
                NameSample sample = (NameSample)stream.read();
                Assertions.assertNotNull((Object)sample);
            }
        });
    }
}

