/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats.muc;

import java.io.IOException;
import opennlp.tools.formats.muc.DocumentSplitterStream;
import opennlp.tools.util.ObjectStreamUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DocumentSplitterStreamTest {
    @Test
    void testSplitTwoDocuments() throws IOException {
        StringBuilder docsString = new StringBuilder();
        for (int i = 0; i < 2; ++i) {
            docsString.append("<DOC>\n");
            docsString.append("test document #").append(i).append("\n");
            docsString.append("</DOC>\n");
        }
        try (DocumentSplitterStream docs = new DocumentSplitterStream(ObjectStreamUtils.createObjectStream((Object[])new String[]{docsString.toString()}));){
            String doc1 = (String)docs.read();
            Assertions.assertEquals((int)(docsString.length() / 2), (int)(doc1.length() + 1));
            Assertions.assertTrue((boolean)doc1.contains("#0"));
            String doc2 = (String)docs.read();
            Assertions.assertEquals((int)(docsString.length() / 2), (int)(doc2.length() + 1));
            Assertions.assertTrue((boolean)doc2.contains("#1"));
            Assertions.assertNull((Object)docs.read());
            Assertions.assertNull((Object)docs.read());
        }
    }
}

