/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats.masc;

import java.io.FileFilter;
import java.io.IOException;
import opennlp.tools.formats.masc.AbstractMascSampleStreamTest;
import opennlp.tools.formats.masc.MascDocumentStream;
import opennlp.tools.formats.masc.MascTokenSampleStream;
import opennlp.tools.tokenize.TokenSample;
import opennlp.tools.tokenize.Tokenizer;
import opennlp.tools.tokenize.TokenizerEvaluationMonitor;
import opennlp.tools.tokenize.TokenizerEvaluator;
import opennlp.tools.tokenize.TokenizerFactory;
import opennlp.tools.tokenize.TokenizerME;
import opennlp.tools.tokenize.TokenizerModel;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.Span;
import opennlp.tools.util.TrainingParameters;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class MascTokenSampleStreamTest
extends AbstractMascSampleStreamTest {
    private MascTokenSampleStream stream;

    @Override
    @BeforeEach
    public void setup() throws IOException {
        super.setup();
        FileFilter fileFilter = pathname -> pathname.getName().contains("MASC");
        this.stream = new MascTokenSampleStream((ObjectStream)new MascDocumentStream(this.directory, true, fileFilter));
        Assertions.assertNotNull((Object)this.stream);
    }

    @Test
    void read() {
        try {
            TokenSample s = this.stream.read();
            String expectedString = "This is a test Sentence.";
            Assertions.assertEquals((Object)expectedString, (Object)s.getText());
            Object[] expectedTags = new Span[]{new Span(0, 4), new Span(5, 7), new Span(8, 9), new Span(10, 14), new Span(15, 23), new Span(23, 24)};
            Assertions.assertArrayEquals((Object[])expectedTags, (Object[])s.getTokenSpans());
            s = this.stream.read();
            String expectedTokens = "This is 'nother test sentence.";
            Assertions.assertEquals((Object)expectedTokens, (Object)s.getText());
            expectedTags = new Span[]{new Span(0, 4), new Span(5, 7), new Span(8, 15), new Span(16, 20), new Span(21, 29), new Span(29, 30)};
            Assertions.assertArrayEquals((Object[])expectedTags, (Object[])s.getTokenSpans());
        }
        catch (IOException e) {
            Assertions.fail((String)("IO Exception: " + e.getMessage()));
        }
    }

    @Test
    void close() {
        try {
            this.stream.close();
            TokenSample tokenSample = this.stream.read();
        }
        catch (IOException e) {
            Assertions.assertEquals((Object)"You are reading an empty document stream. Did you close it?", (Object)e.getMessage());
        }
    }

    @Test
    void reset() {
        try {
            TokenSample s = this.stream.read();
            s = this.stream.read();
            s = this.stream.read();
            Assertions.assertNull((Object)s);
            this.stream.reset();
            s = this.stream.read();
            String expectedString = "This is a test Sentence.";
            Assertions.assertEquals((Object)expectedString, (Object)s.getText());
            Object[] expectedTags = new Span[]{new Span(0, 4), new Span(5, 7), new Span(8, 9), new Span(10, 14), new Span(15, 23), new Span(23, 24)};
            Assertions.assertArrayEquals((Object[])expectedTags, (Object[])s.getTokenSpans());
        }
        catch (IOException e) {
            Assertions.fail((String)("IO Exception: " + e.getMessage()));
        }
    }

    @Test
    void train() {
        try {
            FileFilter fileFilter = pathname -> pathname.getName().contains("");
            MascTokenSampleStream trainTokens = new MascTokenSampleStream((ObjectStream)new MascDocumentStream(this.directory, true, fileFilter));
            TrainingParameters trainingParameters = new TrainingParameters();
            trainingParameters.put("Iterations", 20);
            TokenizerModel model = TokenizerME.train((ObjectStream)trainTokens, (TokenizerFactory)new TokenizerFactory("en", null, false, null), (TrainingParameters)trainingParameters);
            MascTokenSampleStream testTokens = new MascTokenSampleStream((ObjectStream)new MascDocumentStream(this.directory, true, fileFilter));
            TokenizerEvaluator evaluator = new TokenizerEvaluator((Tokenizer)new TokenizerME(model), new TokenizerEvaluationMonitor[0]);
            evaluator.evaluate((ObjectStream)testTokens);
        }
        catch (Exception e) {
            Assertions.fail((String)"Exception raised", (Throwable)e);
        }
    }
}

