/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats.masc;

import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import opennlp.tools.formats.masc.AbstractMascSampleStreamTest;
import opennlp.tools.formats.masc.MascDocumentStream;
import opennlp.tools.formats.masc.MascSentenceSampleStream;
import opennlp.tools.sentdetect.SentenceDetector;
import opennlp.tools.sentdetect.SentenceDetectorEvaluationMonitor;
import opennlp.tools.sentdetect.SentenceDetectorEvaluator;
import opennlp.tools.sentdetect.SentenceDetectorFactory;
import opennlp.tools.sentdetect.SentenceDetectorME;
import opennlp.tools.sentdetect.SentenceModel;
import opennlp.tools.sentdetect.SentenceSample;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.Span;
import opennlp.tools.util.TrainingParameters;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

public class MascSentenceSampleStreamTest
extends AbstractMascSampleStreamTest {
    private MascSentenceSampleStream stream;

    @Override
    @BeforeEach
    public void setup() throws IOException {
        super.setup();
        FileFilter fileFilter = pathname -> pathname.getName().contains("MASC");
        this.stream = new MascSentenceSampleStream((ObjectStream)new MascDocumentStream(this.directory, true, fileFilter), 2);
        Assertions.assertNotNull((Object)this.stream);
    }

    @Test
    void reset() {
        try {
            SentenceSample testSample = this.stream.read();
            testSample = this.stream.read();
            Assertions.assertNull((Object)testSample);
            this.stream.reset();
            testSample = this.stream.read();
            Assertions.assertNotNull((Object)testSample);
            String documentText = "This is a test Sentence. This is 'nother test sentence. ";
            ArrayList<Span> sentenceSpans = new ArrayList<Span>();
            sentenceSpans.add(new Span(0, 24));
            sentenceSpans.add(new Span(25, 55));
            SentenceSample expectedSample = new SentenceSample((CharSequence)documentText, sentenceSpans.toArray(new Span[0]));
            Assertions.assertEquals((Object)testSample.toString(), (Object)expectedSample.toString());
        }
        catch (IOException e) {
            Assertions.fail((String)"IO Exception");
        }
    }

    @Test
    void close() {
        try {
            this.stream.close();
            this.stream.read();
        }
        catch (IOException e) {
            Assertions.assertEquals((Object)"You are reading an empty document stream. Did you close it?", (Object)e.getMessage());
        }
    }

    @Test
    void read() {
        FileFilter fileFilter = pathname -> pathname.getName().contains("");
        try {
            MascSentenceSampleStream stream = new MascSentenceSampleStream((ObjectStream)new MascDocumentStream(this.directory, true, fileFilter), 2);
            String documentText = "This is a test Sentence. This is 'nother test sentence. ";
            ArrayList<Span> sentenceSpans = new ArrayList<Span>();
            sentenceSpans.add(new Span(0, 24));
            sentenceSpans.add(new Span(25, 55));
            SentenceSample expectedSample = new SentenceSample((CharSequence)documentText, sentenceSpans.toArray(new Span[0]));
            SentenceSample testSample = stream.read();
            Assertions.assertEquals((Object)testSample.toString(), (Object)expectedSample.toString());
            testSample = stream.read();
            Assertions.assertNull((Object)testSample);
        }
        catch (IOException e) {
            Assertions.fail((String)"IO Exception", (Throwable)e);
        }
    }

    @Test
    @Disabled
    void train() {
        try {
            FileFilter fileFilter = pathname -> pathname.getName().contains("");
            MascSentenceSampleStream trainSentences = new MascSentenceSampleStream((ObjectStream)new MascDocumentStream(this.directory, true, fileFilter), 1);
            TrainingParameters trainingParameters = new TrainingParameters();
            trainingParameters.put("Iterations", 20);
            SentenceModel model = SentenceDetectorME.train((String)"en", (ObjectStream)trainSentences, (SentenceDetectorFactory)new SentenceDetectorFactory(), (TrainingParameters)trainingParameters);
            MascSentenceSampleStream testPOS = new MascSentenceSampleStream((ObjectStream)new MascDocumentStream(this.directory, true, fileFilter), 1);
            SentenceDetectorEvaluator evaluator = new SentenceDetectorEvaluator((SentenceDetector)new SentenceDetectorME(model), new SentenceDetectorEvaluationMonitor[0]);
            evaluator.evaluate((ObjectStream)testPOS);
        }
        catch (Exception e) {
            Assertions.fail((String)"Exception raised", (Throwable)e);
        }
    }
}

