/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats.masc;

import java.io.IOException;
import opennlp.tools.cmdline.ObjectStreamFactory;
import opennlp.tools.cmdline.StreamFactoryRegistry;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.formats.AbstractSampleStreamFactory;
import opennlp.tools.formats.AbstractSampleStreamFactoryTest;
import opennlp.tools.formats.masc.MascSentenceSampleStreamFactory;
import opennlp.tools.sentdetect.SentenceSample;
import opennlp.tools.util.ObjectStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class MascSentenceSampleStreamFactoryTest
extends AbstractSampleStreamFactoryTest<SentenceSample, MascSentenceSampleStreamFactory.Parameters> {
    private MascSentenceSampleStreamFactory factory;
    private String sampleFileFullPath;

    @Override
    protected AbstractSampleStreamFactory<SentenceSample, MascSentenceSampleStreamFactory.Parameters> getFactory() {
        return this.factory;
    }

    @Override
    protected String getDataFilePath() {
        return this.sampleFileFullPath;
    }

    @BeforeAll
    static void initEnv() {
        MascSentenceSampleStreamFactory.registerFactory();
    }

    @BeforeEach
    void setUp() {
        ObjectStreamFactory f = StreamFactoryRegistry.getFactory(SentenceSample.class, (String)"masc");
        Assertions.assertInstanceOf(MascSentenceSampleStreamFactory.class, (Object)f);
        this.factory = (MascSentenceSampleStreamFactory)f;
        Assertions.assertEquals(MascSentenceSampleStreamFactory.Parameters.class, (Object)this.factory.getParameters());
        this.sampleFileFullPath = this.getResourceWithoutPrefix("opennlp/tools/formats/masc/").getPath();
    }

    @ParameterizedTest
    @ValueSource(strings={"True", "False"})
    void testCreateWithValidParameter(String recurrentSearch) throws IOException {
        try (ObjectStream stream = this.factory.create(new String[]{"-fileFilter", "fakeMASC", "-sentencesPerSample", "5", "-recurrentSearch", recurrentSearch, "-data", this.sampleFileFullPath});){
            SentenceSample sample = (SentenceSample)stream.read();
            Assertions.assertNotNull((Object)sample);
        }
    }

    @Override
    @Test
    protected void testCreateWithInvalidDataFilePath() {
        Assertions.assertThrows(TerminateToolException.class, () -> {
            try (ObjectStream stream = this.getFactory().create(new String[]{"-fileFilter", "fakeMASC", "-sentencesPerSample", "5", "-recurrentSearch", "True", "-data", this.getDataFilePath() + "xyz"});){
                SentenceSample sample = (SentenceSample)stream.read();
                Assertions.assertNotNull((Object)sample);
            }
        });
    }
}

