/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats.masc;

import java.io.FileFilter;
import java.io.IOException;
import opennlp.tools.formats.masc.AbstractMascSampleStreamTest;
import opennlp.tools.formats.masc.MascDocumentStream;
import opennlp.tools.formats.masc.MascPOSSampleStream;
import opennlp.tools.postag.POSEvaluator;
import opennlp.tools.postag.POSModel;
import opennlp.tools.postag.POSSample;
import opennlp.tools.postag.POSTagger;
import opennlp.tools.postag.POSTaggerEvaluationMonitor;
import opennlp.tools.postag.POSTaggerFactory;
import opennlp.tools.postag.POSTaggerME;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.TrainingParameters;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class MascPOSSampleStreamTest
extends AbstractMascSampleStreamTest {
    private MascPOSSampleStream stream;

    @Override
    @BeforeEach
    public void setup() throws IOException {
        super.setup();
        FileFilter fileFilter = pathname -> pathname.getName().contains("MASC");
        this.stream = new MascPOSSampleStream((ObjectStream)new MascDocumentStream(this.directory, true, fileFilter));
        Assertions.assertNotNull((Object)this.stream);
    }

    @Test
    void read() {
        try {
            POSSample s = this.stream.read();
            Object[] expectedTokens = new String[]{"This", "is", "a", "test", "Sentence", "."};
            Assertions.assertArrayEquals((Object[])expectedTokens, (Object[])s.getSentence());
            Object[] expectedTags = new String[]{"DT", "VB", "AT", "NN", "NN", "."};
            Assertions.assertArrayEquals((Object[])expectedTags, (Object[])s.getTags());
            s = this.stream.read();
            expectedTokens = new String[]{"This", "is", "'nother", "test", "sentence", "."};
            Assertions.assertArrayEquals((Object[])expectedTokens, (Object[])s.getSentence());
            expectedTags = new String[]{"DT", "VB", "RB", "NN", "NN", "."};
            Assertions.assertArrayEquals((Object[])expectedTags, (Object[])s.getTags());
        }
        catch (IOException e) {
            Assertions.fail((String)("IO Exception: " + e.getMessage()));
        }
    }

    @Test
    void close() {
        try {
            this.stream.close();
            POSSample pOSSample = this.stream.read();
        }
        catch (IOException e) {
            Assertions.assertEquals((Object)"You are reading an empty document stream. Did you close it?", (Object)e.getMessage());
        }
    }

    @Test
    void reset() {
        try {
            POSSample s = this.stream.read();
            s = this.stream.read();
            s = this.stream.read();
            Assertions.assertNull((Object)s);
            this.stream.reset();
            s = this.stream.read();
            Object[] expectedTokens = new String[]{"This", "is", "a", "test", "Sentence", "."};
            Assertions.assertArrayEquals((Object[])expectedTokens, (Object[])s.getSentence());
            Object[] expectedTags = new String[]{"DT", "VB", "AT", "NN", "NN", "."};
            Assertions.assertArrayEquals((Object[])expectedTags, (Object[])s.getTags());
        }
        catch (IOException e) {
            Assertions.fail((String)("IO Exception: " + e.getMessage()));
        }
    }

    @Test
    void train() {
        try {
            FileFilter fileFilter = pathname -> pathname.getName().contains("");
            MascPOSSampleStream trainPOS = new MascPOSSampleStream((ObjectStream)new MascDocumentStream(this.directory, true, fileFilter));
            TrainingParameters trainingParameters = new TrainingParameters();
            trainingParameters.put("Iterations", 20);
            POSModel model = POSTaggerME.train((String)"en", (ObjectStream)trainPOS, (TrainingParameters)trainingParameters, (POSTaggerFactory)new POSTaggerFactory());
            MascPOSSampleStream testPOS = new MascPOSSampleStream((ObjectStream)new MascDocumentStream(this.directory, true, fileFilter));
            POSEvaluator evaluator = new POSEvaluator((POSTagger)new POSTaggerME(model), new POSTaggerEvaluationMonitor[0]);
            evaluator.evaluate((ObjectStream)testPOS);
        }
        catch (Exception e) {
            Assertions.fail((String)"Exception raised", (Throwable)e);
        }
    }
}

