/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats.masc;

import java.io.FileFilter;
import java.io.IOException;
import opennlp.tools.formats.masc.AbstractMascSampleStreamTest;
import opennlp.tools.formats.masc.MascDocumentStream;
import opennlp.tools.formats.masc.MascNamedEntitySampleStream;
import opennlp.tools.namefind.NameFinderME;
import opennlp.tools.namefind.NameSample;
import opennlp.tools.namefind.TokenNameFinder;
import opennlp.tools.namefind.TokenNameFinderEvaluationMonitor;
import opennlp.tools.namefind.TokenNameFinderEvaluator;
import opennlp.tools.namefind.TokenNameFinderFactory;
import opennlp.tools.namefind.TokenNameFinderModel;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.Span;
import opennlp.tools.util.TrainingParameters;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class MascNamedEntitySampleStreamTest
extends AbstractMascSampleStreamTest {
    private MascNamedEntitySampleStream stream;

    @Override
    @BeforeEach
    public void setup() throws IOException {
        super.setup();
        FileFilter fileFilter = pathname -> pathname.getName().contains("MASC");
        this.stream = new MascNamedEntitySampleStream((ObjectStream)new MascDocumentStream(this.directory, true, fileFilter));
        Assertions.assertNotNull((Object)this.stream);
    }

    @Test
    void read() {
        try {
            NameSample s = this.stream.read();
            Object[] expectedTokens = new String[]{"This", "is", "a", "test", "Sentence", "."};
            Assertions.assertArrayEquals((Object[])expectedTokens, (Object[])s.getSentence());
            Object[] expectedTags = new Span[]{new Span(4, 5, "org")};
            Object[] returnedTags = s.getNames();
            Assertions.assertEquals((int)expectedTags.length, (int)returnedTags.length);
            Assertions.assertArrayEquals((Object[])expectedTags, (Object[])returnedTags);
            s = this.stream.read();
            expectedTokens = new String[]{"This", "is", "'nother", "test", "sentence", "."};
            Assertions.assertArrayEquals((Object[])expectedTokens, (Object[])s.getSentence());
            expectedTags = new Span[]{};
            returnedTags = s.getNames();
            Assertions.assertArrayEquals((Object[])expectedTags, (Object[])returnedTags);
        }
        catch (IOException e) {
            Assertions.fail((String)("IO Exception: " + e.getMessage()));
        }
    }

    @Test
    void close() {
        try {
            this.stream.close();
            NameSample nameSample = this.stream.read();
        }
        catch (IOException e) {
            Assertions.assertEquals((Object)"You are reading an empty document stream. Did you close it?", (Object)e.getMessage());
        }
    }

    @Test
    void reset() {
        try {
            NameSample s = this.stream.read();
            s = this.stream.read();
            s = this.stream.read();
            Assertions.assertNull((Object)s);
            this.stream.reset();
            s = this.stream.read();
            Object[] expectedTokens = new String[]{"This", "is", "a", "test", "Sentence", "."};
            Assertions.assertArrayEquals((Object[])expectedTokens, (Object[])s.getSentence());
            Object[] expectedTags = new Span[]{new Span(4, 5, "org")};
            Object[] returnedTags = s.getNames();
            Assertions.assertEquals((int)expectedTags.length, (int)returnedTags.length);
            Assertions.assertArrayEquals((Object[])expectedTags, (Object[])returnedTags);
        }
        catch (IOException e) {
            Assertions.fail((String)("IO Exception: " + e.getMessage()));
        }
    }

    @Test
    void train() {
        try {
            FileFilter fileFilter = pathname -> pathname.getName().contains("");
            MascNamedEntitySampleStream trainSample = new MascNamedEntitySampleStream((ObjectStream)new MascDocumentStream(this.directory, true, fileFilter));
            TrainingParameters trainingParameters = new TrainingParameters();
            trainingParameters.put("Iterations", 100);
            TokenNameFinderModel model = NameFinderME.train((String)"en", null, (ObjectStream)trainSample, (TrainingParameters)trainingParameters, (TokenNameFinderFactory)new TokenNameFinderFactory());
            MascNamedEntitySampleStream testNames = new MascNamedEntitySampleStream((ObjectStream)new MascDocumentStream(this.directory, true, fileFilter));
            TokenNameFinderEvaluator evaluator = new TokenNameFinderEvaluator((TokenNameFinder)new NameFinderME(model), new TokenNameFinderEvaluationMonitor[0]);
            evaluator.evaluate((ObjectStream)testNames);
        }
        catch (Exception e) {
            Assertions.fail((String)"Exception raised", (Throwable)e);
        }
    }
}

