/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats.letsmt;

import java.io.IOException;
import opennlp.tools.cmdline.ObjectStreamFactory;
import opennlp.tools.cmdline.StreamFactoryRegistry;
import opennlp.tools.formats.AbstractSampleStreamFactory;
import opennlp.tools.formats.AbstractSampleStreamFactoryTest;
import opennlp.tools.formats.letsmt.LetsmtSentenceStreamFactory;
import opennlp.tools.sentdetect.SentenceSample;
import opennlp.tools.util.ObjectStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class LetsmtSentenceStreamFactoryTest
extends AbstractSampleStreamFactoryTest<SentenceSample, LetsmtSentenceStreamFactory.Parameters> {
    private static final String DETOKENIZER_FILE = "opennlp/tools/tokenize/latin-detokenizer.xml";
    private static final String SAMPLE_01 = "letsmt-with-words.xml";
    private LetsmtSentenceStreamFactory factory;
    private String detokFileFullPath;
    private String sampleFileFullPath;

    @Override
    protected AbstractSampleStreamFactory<SentenceSample, LetsmtSentenceStreamFactory.Parameters> getFactory() {
        return this.factory;
    }

    @Override
    protected String getDataFilePath() {
        return this.sampleFileFullPath;
    }

    @BeforeAll
    static void initEnv() {
        LetsmtSentenceStreamFactory.registerFactory();
    }

    @BeforeEach
    void setUp() {
        ObjectStreamFactory f = StreamFactoryRegistry.getFactory(SentenceSample.class, (String)"letsmt");
        Assertions.assertInstanceOf(LetsmtSentenceStreamFactory.class, (Object)f);
        this.factory = (LetsmtSentenceStreamFactory)f;
        Assertions.assertEquals(LetsmtSentenceStreamFactory.Parameters.class, (Object)this.factory.getParameters());
        this.sampleFileFullPath = this.getResourceWithoutPrefix("opennlp/tools/formats/letsmt/letsmt-with-words.xml").getPath();
        this.detokFileFullPath = this.getResourceWithoutPrefix(DETOKENIZER_FILE).getPath();
    }

    @Test
    void testCreateWithValidParameter() throws IOException {
        try (ObjectStream stream = this.factory.create(new String[]{"-detokenizer", this.detokFileFullPath, "-data", this.sampleFileFullPath});){
            SentenceSample sample = (SentenceSample)stream.read();
            Assertions.assertNotNull((Object)sample);
        }
    }
}

