/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats.letsmt;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import opennlp.tools.formats.AbstractFormatTest;
import opennlp.tools.formats.letsmt.LetsmtDocument;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class LetsmtDocumentTest
extends AbstractFormatTest {
    @Test
    void testParsingSimpleDoc() throws IOException {
        try (InputStream letsmtXmlIn = this.getResourceStream("letsmt/letsmt-with-words.xml");){
            LetsmtDocument doc = LetsmtDocument.parse((InputStream)letsmtXmlIn);
            List sents = doc.getSentences();
            Assertions.assertEquals((int)2, (int)sents.size());
            LetsmtDocument.LetsmtSentence sent1 = (LetsmtDocument.LetsmtSentence)sents.get(0);
            Assertions.assertNull((Object)sent1.getNonTokenizedText());
            Assertions.assertArrayEquals((Object[])new String[]{"The", "Apache", "Software", "Foundation", "uses", "various", "licenses", "to", "distribute", "software", "and", "documentation", ",", "to", "accept", "regular", "contributions", "from", "individuals", "and", "corporations", ",", "and", "to", "accept", "larger", "grants", "of", "existing", "software", "products", "."}, (Object[])sent1.getTokens());
            LetsmtDocument.LetsmtSentence sent2 = (LetsmtDocument.LetsmtSentence)sents.get(1);
            Assertions.assertNull((Object)sent2.getNonTokenizedText());
            Assertions.assertArrayEquals((Object[])new String[]{"All", "software", "produced", "by", "The", "Apache", "Software", "Foundation", "or", "any", "of", "its", "projects", "or", "subjects", "is", "licensed", "according", "to", "the", "terms", "of", "the", "documents", "listed", "below", "."}, (Object[])sent2.getTokens());
        }
    }
}

