/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats.leipzig;

import java.io.File;
import java.io.IOException;
import opennlp.tools.formats.leipzig.LeipzigLanguageSampleStream;
import opennlp.tools.util.InvalidFormatException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class LeipzigLanguageSampleStreamTest {
    private static final String testDataPath = LeipzigLanguageSampleStreamTest.class.getClassLoader().getResource("opennlp/tools/formats/leipzig/samples").getPath();
    @TempDir
    File emptyTempDir;

    @Test
    void testReadSentenceFiles() {
        int samplesPerLanguage = 2;
        int sentencesPerSample = 1;
        try (LeipzigLanguageSampleStream stream = new LeipzigLanguageSampleStream(new File(testDataPath), sentencesPerSample, samplesPerLanguage);){
            int count = 0;
            while (stream.read() != null) {
                ++count;
            }
            Assertions.assertEquals((int)4, (int)count);
        }
        catch (IOException e) {
            Assertions.fail();
        }
    }

    @Test
    void testNotEnoughSentences() {
        Assertions.assertThrows(InvalidFormatException.class, () -> {
            int samplesPerLanguage = 2;
            int sentencesPerSample = 2;
            try (LeipzigLanguageSampleStream stream = new LeipzigLanguageSampleStream(new File(testDataPath), sentencesPerSample, samplesPerLanguage);){
                while (stream.read() != null) {
                }
            }
        });
    }

    @Test
    void testReadSentenceFilesWithEmptyDir() {
        int samplesPerLanguage = 2;
        int sentencesPerSample = 1;
        try (LeipzigLanguageSampleStream stream = new LeipzigLanguageSampleStream(this.emptyTempDir, sentencesPerSample, samplesPerLanguage);){
            int count = 0;
            while (stream.read() != null) {
                ++count;
            }
            Assertions.assertEquals((int)0, (int)count);
        }
        catch (IOException e) {
            Assertions.fail();
        }
    }
}

