/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats.leipzig;

import java.io.IOException;
import opennlp.tools.cmdline.ObjectStreamFactory;
import opennlp.tools.cmdline.StreamFactoryRegistry;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.formats.AbstractSampleStreamFactory;
import opennlp.tools.formats.AbstractSampleStreamFactoryTest;
import opennlp.tools.formats.leipzig.LeipzigLanguageSampleStreamFactory;
import opennlp.tools.langdetect.LanguageSample;
import opennlp.tools.util.ObjectStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class LeipzigLanguageSampleStreamFactoryTest
extends AbstractSampleStreamFactoryTest<LanguageSample, LeipzigLanguageSampleStreamFactory.Parameters> {
    private LeipzigLanguageSampleStreamFactory factory;
    private String sampleFileFullPath;

    @Override
    protected AbstractSampleStreamFactory<LanguageSample, LeipzigLanguageSampleStreamFactory.Parameters> getFactory() {
        return this.factory;
    }

    @Override
    protected String getDataFilePath() {
        return this.sampleFileFullPath;
    }

    @BeforeAll
    static void initEnv() {
        LeipzigLanguageSampleStreamFactory.registerFactory();
    }

    @BeforeEach
    void setUp() {
        ObjectStreamFactory f = StreamFactoryRegistry.getFactory(LanguageSample.class, (String)"leipzig");
        Assertions.assertInstanceOf(LeipzigLanguageSampleStreamFactory.class, (Object)f);
        this.factory = (LeipzigLanguageSampleStreamFactory)f;
        Assertions.assertEquals(LeipzigLanguageSampleStreamFactory.Parameters.class, (Object)this.factory.getParameters());
        this.sampleFileFullPath = this.getResourceWithoutPrefix("opennlp/tools/formats/leipzig/samples").getPath();
    }

    @Test
    void testCreateWithValidParameter() throws IOException {
        try (ObjectStream stream = this.factory.create(new String[]{"-sentencesPerSample", "1", "-samplesPerLanguage", "1", "-samplesToSkip", "1", "-sentencesDir", this.sampleFileFullPath});){
            LanguageSample sample = (LanguageSample)stream.read();
            Assertions.assertNotNull((Object)sample);
        }
    }

    @Test
    void testCreateWithValidParametersTooLarge() {
        Assertions.assertThrows(TerminateToolException.class, () -> {
            try (ObjectStream stream = this.factory.create(new String[]{"-sentencesPerSample", "2", "-samplesPerLanguage", "2", "-samplesToSkip", "1", "-sentencesDir", this.sampleFileFullPath});){
                LanguageSample sample = (LanguageSample)stream.read();
                Assertions.assertNotNull((Object)sample);
            }
        });
    }

    @Override
    @Test
    protected void testCreateWithInvalidDataFilePath() {
        Assertions.assertThrows(TerminateToolException.class, () -> {
            try (ObjectStream stream = this.factory.create(new String[]{"-sentencesPerSample", "2", "-samplesPerLanguage", "2", "-samplesToSkip", "1", "-sentencesDir", this.sampleFileFullPath + "xyz"});){
                LanguageSample sample = (LanguageSample)stream.read();
                Assertions.assertNotNull((Object)sample);
            }
        });
    }
}

