/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats.irishsentencebank;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import opennlp.tools.formats.AbstractFormatTest;
import opennlp.tools.formats.irishsentencebank.IrishSentenceBankDocument;
import opennlp.tools.tokenize.TokenSample;
import opennlp.tools.util.Span;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class IrishSentenceBankDocumentTest
extends AbstractFormatTest {
    @Test
    void testParsingSimpleDoc() throws IOException {
        try (InputStream irishSBXmlIn = this.getResourceStream("irishsentencebank/irishsentencebank-sample.xml");){
            IrishSentenceBankDocument doc = IrishSentenceBankDocument.parse((InputStream)irishSBXmlIn);
            List sents = doc.getSentences();
            Assertions.assertEquals((int)2, (int)sents.size());
            IrishSentenceBankDocument.IrishSentenceBankSentence sent1 = (IrishSentenceBankDocument.IrishSentenceBankSentence)sents.get(0);
            IrishSentenceBankDocument.IrishSentenceBankSentence sent2 = (IrishSentenceBankDocument.IrishSentenceBankSentence)sents.get(1);
            Assertions.assertEquals((Object)"A Dhia, t\u00e1 m\u00e9 ag iompar clainne!", (Object)sent1.getOriginal());
            IrishSentenceBankDocument.IrishSentenceBankFlex[] flex = sent1.getFlex();
            Assertions.assertEquals((int)7, (int)flex.length);
            Assertions.assertEquals((Object)"A", (Object)flex[0].getSurface());
            Assertions.assertArrayEquals((Object[])new String[]{"a"}, (Object[])flex[0].getFlex());
            IrishSentenceBankDocument.IrishSentenceBankFlex[] flex2 = sent2.getFlex();
            Assertions.assertEquals((Object)"\u00f3n", (Object)flex2[4].getSurface());
            Assertions.assertArrayEquals((Object[])new String[]{"\u00f3", "an"}, (Object[])flex2[4].getFlex());
            Assertions.assertEquals((Object)"Excuse me, are you from the stone age?", (Object)sent2.getTranslation());
            TokenSample ts = sent1.getTokenSample();
            Span[] spans = ts.getTokenSpans();
            Assertions.assertEquals((int)9, (int)spans.length);
            Assertions.assertEquals((int)24, (int)spans[7].getStart());
            Assertions.assertEquals((int)31, (int)spans[7].getEnd());
            Assertions.assertEquals((Object)"clainne", (Object)ts.getText().substring(spans[7].getStart(), spans[7].getEnd()));
        }
    }
}

