/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats.frenchtreebank;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import opennlp.tools.formats.AbstractFormatTest;
import opennlp.tools.formats.frenchtreebank.ConstitParseSampleStream;
import opennlp.tools.parser.Parse;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.ObjectStreamUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ConstitParseSampleStreamTest
extends AbstractFormatTest {
    private final String[] sample1Tokens = new String[]{"L'", "autonomie", "de", "la", "Bundesbank", ",", "la", "politique", "de", "stabilit\u00e9", "qu'", "elle", "a", "fait", "pr\u00e9valoir", "(", "avec", "moins", "de", "succ\u00e8s", "et", "de", "s\u00e9v\u00e9rit\u00e9", "qu'", "on", "ne", "le", "dit", ",", "mais", "tout", "est", "relatif", ")", ",", "est", "une", "pi\u00e8ce", "essentielle", "de", "la", "division", "des", "pouvoirs", "en", "Allemagne", "."};
    private ObjectStream<byte[]> sample;

    @BeforeEach
    public void setup() throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        try (InputStream sampleIn = this.getResourceStream("frenchtreebank/sample1.xml");){
            int length;
            while ((length = sampleIn.read(buffer)) > 0) {
                out.write(buffer, 0, length);
            }
        }
        this.sample = ObjectStreamUtils.createObjectStream((Object[])new byte[][]{out.toByteArray()});
        Assertions.assertNotNull(this.sample);
    }

    @Test
    void testThereIsExactlyOneSent() throws IOException {
        try (ConstitParseSampleStream samples = new ConstitParseSampleStream(this.sample);){
            Assertions.assertNotNull((Object)samples.read());
            Assertions.assertNull((Object)samples.read());
            Assertions.assertNull((Object)samples.read());
        }
    }

    @Test
    void testTokensAreCorrect() throws IOException {
        try (ConstitParseSampleStream samples = new ConstitParseSampleStream(this.sample);){
            Parse p = (Parse)samples.read();
            Parse[] tagNodes = p.getTagNodes();
            Object[] tokens = new String[tagNodes.length];
            for (int ti = 0; ti < tagNodes.length; ++ti) {
                tokens[ti] = tagNodes[ti].getCoveredText();
            }
            Assertions.assertArrayEquals((Object[])this.sample1Tokens, (Object[])tokens);
        }
    }
}

