/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats.frenchtreebank;

import java.io.IOException;
import opennlp.tools.cmdline.ObjectStreamFactory;
import opennlp.tools.cmdline.StreamFactoryRegistry;
import opennlp.tools.formats.AbstractSampleStreamFactory;
import opennlp.tools.formats.AbstractSampleStreamFactoryTest;
import opennlp.tools.formats.frenchtreebank.ConstitParseSampleStreamFactory;
import opennlp.tools.parser.Parse;
import opennlp.tools.util.ObjectStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ConstitParseSampleStreamFactoryTest
extends AbstractSampleStreamFactoryTest<Parse, ConstitParseSampleStreamFactory.Parameters> {
    private ConstitParseSampleStreamFactory factory;
    private String sampleFileFullPath;

    @Override
    protected AbstractSampleStreamFactory<Parse, ConstitParseSampleStreamFactory.Parameters> getFactory() {
        return this.factory;
    }

    @Override
    protected String getDataFilePath() {
        return this.sampleFileFullPath;
    }

    @BeforeAll
    static void initEnv() {
        ConstitParseSampleStreamFactory.registerFactory();
    }

    @BeforeEach
    void setUp() {
        ObjectStreamFactory f = StreamFactoryRegistry.getFactory(Parse.class, (String)"frenchtreebank");
        Assertions.assertInstanceOf(ConstitParseSampleStreamFactory.class, (Object)f);
        this.factory = (ConstitParseSampleStreamFactory)f;
        Assertions.assertEquals(ConstitParseSampleStreamFactory.Parameters.class, (Object)this.factory.getParameters());
        this.sampleFileFullPath = this.getResourceWithoutPrefix("opennlp/tools/formats/frenchtreebank/").getPath();
    }

    @Test
    void testCreateWithValidParameter() throws IOException {
        try (ObjectStream stream = this.factory.create(new String[]{"-data", this.sampleFileFullPath});){
            Parse sample = (Parse)stream.read();
            Assertions.assertNotNull((Object)sample);
        }
    }

    @Override
    @Test
    protected void testCreateWithInvalidDataFilePath() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            try (ObjectStream stream = this.getFactory().create(new String[]{"-data", this.getDataFilePath() + "xyz"});){
                Parse sample = (Parse)stream.read();
                Assertions.assertNotNull((Object)sample);
            }
        });
    }
}

