/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats.convert;

import java.io.IOException;
import opennlp.tools.cmdline.ObjectStreamFactory;
import opennlp.tools.cmdline.StreamFactoryRegistry;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.formats.AbstractSampleStreamFactory;
import opennlp.tools.formats.AbstractSampleStreamFactoryTest;
import opennlp.tools.formats.convert.NameToTokenSampleStreamFactory;
import opennlp.tools.tokenize.TokenSample;
import opennlp.tools.util.ObjectStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class NameToTokenSampleStreamFactoryTest
extends AbstractSampleStreamFactoryTest<TokenSample, NameToTokenSampleStreamFactory.Parameters> {
    private static final String DETOKENIZER_FILE = "opennlp/tools/tokenize/latin-detokenizer.xml";
    private static final String SAMPLE_01 = "name-data-01.sample";
    private NameToTokenSampleStreamFactory factory;
    private String detokFileFullPath;
    private String sampleFileFullPath;

    @Override
    protected AbstractSampleStreamFactory<TokenSample, NameToTokenSampleStreamFactory.Parameters> getFactory() {
        return this.factory;
    }

    @Override
    protected String getDataFilePath() {
        return this.sampleFileFullPath;
    }

    @BeforeAll
    static void initEnv() {
        NameToTokenSampleStreamFactory.registerFactory();
    }

    @BeforeEach
    void setUp() {
        ObjectStreamFactory f = StreamFactoryRegistry.getFactory(TokenSample.class, (String)"namefinder");
        Assertions.assertInstanceOf(NameToTokenSampleStreamFactory.class, (Object)f);
        this.factory = (NameToTokenSampleStreamFactory)f;
        Assertions.assertEquals(NameToTokenSampleStreamFactory.Parameters.class, (Object)this.factory.getParameters());
        this.sampleFileFullPath = this.getResourceWithoutPrefix("opennlp/tools/formats/name-data-01.sample").getPath();
        this.detokFileFullPath = this.getResourceWithoutPrefix(DETOKENIZER_FILE).getPath();
    }

    @Test
    void testCreateWithValidParameter() throws IOException {
        try (ObjectStream stream = this.factory.create(new String[]{"-detokenizer", this.detokFileFullPath, "-data", this.sampleFileFullPath});){
            TokenSample sample = (TokenSample)stream.read();
            Assertions.assertNotNull((Object)sample);
        }
    }

    @Override
    @Test
    protected void testCreateWithInvalidDataFilePath() {
        Assertions.assertThrows(TerminateToolException.class, () -> {
            try (ObjectStream stream = this.factory.create(new String[]{"-detokenizer", this.detokFileFullPath, "-data", this.sampleFileFullPath + "xyz"});){
                TokenSample sample = (TokenSample)stream.read();
                Assertions.assertNotNull((Object)sample);
            }
        });
    }
}

