/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats.conllu;

import opennlp.tools.formats.conllu.ConlluTagset;
import opennlp.tools.formats.conllu.ConlluWordLine;
import opennlp.tools.util.InvalidFormatException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ConlluWordLineTest {
    @Test
    void testParseLine() throws InvalidFormatException {
        ConlluWordLine line = new ConlluWordLine("12\tH\u00e4nden\tHand\tNOUN\tNN\tCase=Dat|Number=Plur\t5\tnmod\t_\t_");
        Assertions.assertEquals((Object)"12", (Object)line.getId());
        Assertions.assertEquals((Object)"H\u00e4nden", (Object)line.getForm());
        Assertions.assertEquals((Object)"Hand", (Object)line.getLemma());
        Assertions.assertEquals((Object)"NOUN", (Object)line.getPosTag(ConlluTagset.U));
        Assertions.assertEquals((Object)"NN", (Object)line.getPosTag(ConlluTagset.X));
        Assertions.assertEquals((Object)"Case=Dat|Number=Plur", (Object)line.getFeats());
        Assertions.assertEquals((Object)"5", (Object)line.getHead());
        Assertions.assertEquals((Object)"nmod", (Object)line.getDeprel());
        Assertions.assertEquals((Object)"_", (Object)line.getDeps());
        Assertions.assertEquals((Object)"_", (Object)line.getMisc());
    }
}

