/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats.conllu;

import java.io.IOException;
import opennlp.tools.formats.conllu.AbstractConlluSampleStreamTest;
import opennlp.tools.formats.conllu.ConlluStream;
import opennlp.tools.formats.conllu.ConlluTokenSampleStream;
import opennlp.tools.tokenize.TokenSample;
import opennlp.tools.util.ObjectStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ConlluTokenSampleStreamTest
extends AbstractConlluSampleStreamTest<TokenSample> {
    @Test
    void testParseTwoSentences() throws IOException {
        ConlluStream cStream = this.getStream("de-ud-train-sample.conllu");
        try (ConlluTokenSampleStream stream = new ConlluTokenSampleStream((ObjectStream)cStream);){
            TokenSample expected1 = TokenSample.parse((String)"Fachlich kompetent<SPLIT>, sehr gute Beratung und ein freundliches Team<SPLIT>.", (String)"<SPLIT>");
            Assertions.assertEquals((Object)expected1, (Object)stream.read());
            TokenSample expected2 = TokenSample.parse((String)"Beiden Zahn\u00e4rzten verdanke ich einen neuen Biss und dadurch endlich keine R\u00fcckenschmerzen mehr<SPLIT>.", (String)"<SPLIT>");
            Assertions.assertEquals((Object)expected2, (Object)stream.read());
            Assertions.assertNull((Object)stream.read(), (String)"Stream must be exhausted");
        }
    }

    @Test
    void testParseContraction() throws IOException {
        ConlluStream cStream = this.getStream("pt_br-ud-sample.conllu");
        try (ConlluTokenSampleStream stream = new ConlluTokenSampleStream((ObjectStream)cStream);){
            TokenSample expected1 = TokenSample.parse((String)"Numa reuni\u00e3o entre representantes da Secretaria da Crian\u00e7a do DF ea ju\u00edza da Vara de Execu\u00e7\u00f5es de Medidas Socioeducativas<SPLIT>, Lav\u00ednia Tupi Vieira Fonseca<SPLIT>, ficou acordado que dos 25 internos<SPLIT>, 12 ser\u00e3o internados na Unidade de Planaltina e os outros 13 devem retornar para a Unidade do Recanto das Emas<SPLIT>, antigo Ciago<SPLIT>.", (String)"<SPLIT>");
            TokenSample predicted = (TokenSample)stream.read();
            Assertions.assertEquals((Object)expected1, (Object)predicted);
        }
    }

    @Test
    void testParseSpanishS300() throws IOException {
        ConlluStream cStream = this.getStream("es-ud-sample.conllu");
        try (ConlluTokenSampleStream stream = new ConlluTokenSampleStream((ObjectStream)cStream);){
            TokenSample expected1 = TokenSample.parse((String)"Dig\u00e1moslo claramente<SPLIT>, la insurgencia se ha pronunciado mucho m\u00e1s claramente respecto al tema de la paz que el Estado<SPLIT>, como lo demuestra el fragmento que Berm\u00fadez cita de la respuesta de \"<SPLIT>Gabino<SPLIT>\" a Piedad C\u00f3rdoba<SPLIT>, en la cual no se plantea ni siquiera \"<SPLIT>esperar un mejor gobierno<SPLIT>\"<SPLIT>.", (String)"<SPLIT>");
            TokenSample predicted = (TokenSample)stream.read();
            Assertions.assertEquals((Object)expected1, (Object)predicted);
        }
    }
}

