/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats.conllu;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Optional;
import opennlp.tools.formats.conllu.AbstractConlluSampleStreamTest;
import opennlp.tools.formats.conllu.ConlluSentence;
import opennlp.tools.formats.conllu.ConlluStream;
import opennlp.tools.sentdetect.SentenceSample;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ConlluStreamTest
extends AbstractConlluSampleStreamTest<SentenceSample> {
    @Test
    void testParseTwoSentences() throws IOException {
        try (ConlluStream stream = this.getStream("de-ud-train-sample.conllu");){
            ConlluSentence sent1 = (ConlluSentence)stream.read();
            Assertions.assertEquals((Object)"train-s21", (Object)sent1.getSentenceIdComment());
            Assertions.assertEquals((Object)"Fachlich kompetent, sehr gute Beratung und ein freundliches Team.", (Object)sent1.getTextComment());
            Assertions.assertEquals((int)11, (int)sent1.getWordLines().size());
            ConlluSentence sent2 = (ConlluSentence)stream.read();
            Assertions.assertEquals((Object)"train-s22", (Object)sent2.getSentenceIdComment());
            Assertions.assertEquals((Object)"Beiden Zahn\u00e4rzten verdanke ich einen neuen Biss und dadurch endlich keine R\u00fcckenschmerzen mehr.", (Object)sent2.getTextComment());
            Assertions.assertEquals((int)14, (int)sent2.getWordLines().size());
            Assertions.assertNull((Object)stream.read(), (String)"Stream must be exhausted");
        }
    }

    @Test
    void testOptionalComments() throws IOException {
        try (ConlluStream stream = this.getStream("full-sample.conllu");){
            ConlluSentence sent1 = (ConlluSentence)stream.read();
            Assertions.assertEquals((Object)"1", (Object)sent1.getSentenceIdComment());
            Assertions.assertEquals((Object)"They buy and sell books.", (Object)sent1.getTextComment());
            Assertions.assertTrue((boolean)sent1.isNewDocument());
            Assertions.assertTrue((boolean)sent1.isNewParagraph());
            Assertions.assertEquals((int)6, (int)sent1.getWordLines().size());
            ConlluSentence sent2 = (ConlluSentence)stream.read();
            Assertions.assertEquals((Object)"2", (Object)sent2.getSentenceIdComment());
            Assertions.assertEquals((Object)"I have no clue.", (Object)sent2.getTextComment());
            Assertions.assertTrue((boolean)sent2.isNewDocument());
            Assertions.assertEquals((int)5, (int)sent2.getWordLines().size());
            ConlluSentence sent3 = (ConlluSentence)stream.read();
            Assertions.assertEquals((Object)"panc0.s4", (Object)sent3.getSentenceIdComment());
            Assertions.assertEquals(Optional.of("tat yath\u0101nu\u015br\u016byate."), (Object)sent3.getTranslit());
            Assertions.assertEquals((Object)"\u0924\u0924\u094d \u092f\u0925\u093e\u0928\u0941\u0936\u094d\u0930\u0942\u092f\u0924\u0947\u0964", (Object)sent3.getTextComment());
            Assertions.assertEquals((int)3, (int)sent3.getWordLines().size());
            Assertions.assertTrue((boolean)sent3.isNewParagraph());
            HashMap<Locale, String> textLang3 = new HashMap<Locale, String>();
            textLang3.put(new Locale("fr"), "Voil\u00e0 ce qui nous est parvenu par la tradition orale.");
            textLang3.put(new Locale("en"), "This is what is heard.");
            Assertions.assertEquals(Optional.of(textLang3), (Object)sent3.getTextLang());
            ConlluSentence sent4 = (ConlluSentence)stream.read();
            Assertions.assertEquals((Object)"mf920901-001-p1s1A", (Object)sent4.getSentenceIdComment());
            Assertions.assertEquals((Object)"Slovensk\u00e1 \u00fastava: pro i proti", (Object)sent4.getTextComment());
            Assertions.assertEquals((int)6, (int)sent4.getWordLines().size());
            Assertions.assertTrue((boolean)sent4.isNewDocument());
            Assertions.assertTrue((boolean)sent4.isNewParagraph());
            Assertions.assertEquals(Optional.of("mf920901-001"), (Object)sent4.getDocumentId());
            Assertions.assertEquals(Optional.of("mf920901-001-p1"), (Object)sent4.getParagraphId());
            Assertions.assertEquals(Optional.of(Collections.singletonMap(new Locale("en"), "Slovak constitution: pros and cons")), (Object)sent4.getTextLang());
            Assertions.assertNull((Object)stream.read(), (String)"Stream must be exhausted");
        }
    }
}

