/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats.conllu;

import java.io.IOException;
import opennlp.tools.formats.conllu.AbstractConlluSampleStreamTest;
import opennlp.tools.formats.conllu.ConlluSentenceSampleStream;
import opennlp.tools.formats.conllu.ConlluStream;
import opennlp.tools.sentdetect.SentenceSample;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.Span;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ConlluSentenceSampleStreamTest
extends AbstractConlluSampleStreamTest<SentenceSample> {
    @Test
    void testParseTwoSentences() throws IOException {
        ConlluStream cStream = this.getStream("de-ud-train-sample.conllu");
        Assertions.assertNotNull((Object)cStream);
        try (ConlluSentenceSampleStream stream = new ConlluSentenceSampleStream((ObjectStream)cStream, 1);){
            SentenceSample sample1 = (SentenceSample)stream.read();
            Assertions.assertEquals((Object)"Fachlich kompetent, sehr gute Beratung und ein freundliches Team.", (Object)sample1.getDocument());
            Assertions.assertEquals((Object)new Span(0, 65), (Object)sample1.getSentences()[0]);
            SentenceSample sample2 = (SentenceSample)stream.read();
            Assertions.assertEquals((Object)"Beiden Zahn\u00e4rzten verdanke ich einen neuen Biss und dadurch endlich keine R\u00fcckenschmerzen mehr.", (Object)sample2.getDocument());
            Assertions.assertEquals((Object)new Span(0, 95), (Object)sample2.getSentences()[0]);
            Assertions.assertNull((Object)stream.read(), (String)"Stream must be exhausted");
        }
        cStream = this.getStream("de-ud-train-sample.conllu");
        Assertions.assertNotNull((Object)cStream);
        stream = new ConlluSentenceSampleStream((ObjectStream)cStream, 3);
        try {
            SentenceSample sample = (SentenceSample)stream.read();
            Assertions.assertEquals((Object)"Fachlich kompetent, sehr gute Beratung und ein freundliches Team. Beiden Zahn\u00e4rzten verdanke ich einen neuen Biss und dadurch endlich keine R\u00fcckenschmerzen mehr.", (Object)sample.getDocument());
            Assertions.assertNull((Object)stream.read(), (String)"Stream must be exhausted");
        }
        finally {
            stream.close();
        }
    }
}

