/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats.conllu;

import java.io.IOException;
import opennlp.tools.formats.conllu.AbstractConlluSampleStreamTest;
import opennlp.tools.formats.conllu.ConlluPOSSampleStream;
import opennlp.tools.formats.conllu.ConlluStream;
import opennlp.tools.formats.conllu.ConlluTagset;
import opennlp.tools.postag.POSSample;
import opennlp.tools.util.ObjectStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ConlluPOSSampleStreamTest
extends AbstractConlluSampleStreamTest<POSSample> {
    @Test
    void testParseContraction() throws IOException {
        ConlluStream cStream = this.getStream("pt_br-ud-sample.conllu");
        Assertions.assertNotNull((Object)cStream);
        try (ConlluPOSSampleStream stream = new ConlluPOSSampleStream((ObjectStream)cStream, ConlluTagset.U);){
            POSSample expected = POSSample.parse((String)"Numa_ADP+DET reuni\u00e3o_NOUN entre_ADP representantes_NOUN da_ADP+DET Secretaria_PROPN da_ADP+DET Crian\u00e7a_PROPN do_ADP+DET DF_PROPN ea_CCONJ ju\u00edza_NOUN da_ADP+DET Vara_PROPN de_ADP Execu\u00e7\u00f5es_PROPN de_ADP Medidas_PROPN Socioeducativas_PROPN ,_PUNCT Lav\u00ednia_PROPN Tupi_PROPN Vieira_PROPN Fonseca_PROPN ,_PUNCT ficou_VERB acordado_ADJ que_CCONJ dos_ADP+DET 25_NUM internos_NOUN ,_PUNCT 12_NUM ser\u00e3o_AUX internados_VERB na_ADP+DET Unidade_PROPN de_ADP Planaltina_PROPN e_CCONJ os_DET outros_DET 13_NUM devem_AUX retornar_VERB para_ADP a_DET Unidade_PROPN do_ADP+DET Recanto_NOUN das_ADP+DET Emas_PROPN ,_PUNCT antigo_ADJ Ciago_PROPN ._PUNCT");
            POSSample predicted = (POSSample)stream.read();
            Assertions.assertEquals((Object)expected, (Object)predicted);
        }
    }

    @Test
    void testParseSpanishS300() throws IOException {
        ConlluStream cStream = this.getStream("es-ud-sample.conllu");
        Assertions.assertNotNull((Object)cStream);
        try (ConlluPOSSampleStream stream = new ConlluPOSSampleStream((ObjectStream)cStream, ConlluTagset.U);){
            POSSample expected1 = POSSample.parse((String)"Dig\u00e1moslo_VERB+PRON+PRON claramente_ADV ,_PUNCT la_DET insurgencia_NOUN se_PRON ha_AUX pronunciado_VERB mucho_PRON m\u00e1s_ADV claramente_ADV respecto_NOUN al_ADP+DET tema_NOUN de_ADP la_DET paz_NOUN que_CCONJ el_DET Estado_NOUN ,_PUNCT como_SCONJ lo_PRON demuestra_VERB el_DET fragmento_NOUN que_SCONJ Berm\u00fadez_PROPN cita_VERB de_ADP la_DET respuesta_NOUN de_ADP \"_PUNCT Gabino_PROPN \"_PUNCT a_ADP Piedad_PROPN C\u00f3rdoba_PROPN ,_PUNCT en_ADP la_DET cual_PRON no_ADV se_PRON plantea_VERB ni_CCONJ siquiera_ADV \"_PUNCT esperar_VERB un_DET mejor_ADJ gobierno_NOUN \"_PUNCT ._PUNCT");
            POSSample predicted = (POSSample)stream.read();
            Assertions.assertEquals((Object)expected1, (Object)predicted);
        }
    }
}

