/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats.conllu;

import java.io.IOException;
import opennlp.tools.cmdline.ObjectStreamFactory;
import opennlp.tools.cmdline.StreamFactoryRegistry;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.formats.AbstractSampleStreamFactory;
import opennlp.tools.formats.AbstractSampleStreamFactoryTest;
import opennlp.tools.formats.conllu.ConlluPOSSampleStreamFactory;
import opennlp.tools.postag.POSSample;
import opennlp.tools.util.ObjectStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class ConlluPOSSampleStreamFactoryTest
extends AbstractSampleStreamFactoryTest<POSSample, ConlluPOSSampleStreamFactory.Parameters> {
    private static final String SAMPLE_01 = "es-ud-sample.conllu";
    private ConlluPOSSampleStreamFactory factory;
    private String sampleFileFullPath;

    @Override
    protected AbstractSampleStreamFactory<POSSample, ConlluPOSSampleStreamFactory.Parameters> getFactory() {
        return this.factory;
    }

    @Override
    protected String getDataFilePath() {
        return this.sampleFileFullPath;
    }

    @BeforeAll
    static void initEnv() {
        ConlluPOSSampleStreamFactory.registerFactory();
    }

    @BeforeEach
    void setUp() {
        ObjectStreamFactory f = StreamFactoryRegistry.getFactory(POSSample.class, (String)"conllu");
        Assertions.assertInstanceOf(ConlluPOSSampleStreamFactory.class, (Object)f);
        this.factory = (ConlluPOSSampleStreamFactory)f;
        Assertions.assertEquals(ConlluPOSSampleStreamFactory.Parameters.class, (Object)this.factory.getParameters());
        this.sampleFileFullPath = this.getResourceWithoutPrefix("opennlp/tools/formats/conllu/es-ud-sample.conllu").getPath();
    }

    @ParameterizedTest
    @ValueSource(strings={"u", "x"})
    void testCreateWithValidParameter(String tagset) throws IOException {
        try (ObjectStream stream = this.factory.create(new String[]{"-tagset", tagset, "-data", this.sampleFileFullPath});){
            POSSample sample = (POSSample)stream.read();
            Assertions.assertNotNull((Object)sample);
        }
    }

    @ParameterizedTest
    @ValueSource(strings={" ", "y"})
    void testCreateWithUnknownTagset(String tagset) {
        Assertions.assertThrows(TerminateToolException.class, () -> {
            try (ObjectStream stream = this.factory.create(new String[]{"-tagset", tagset, "-data", this.sampleFileFullPath});){
                Assertions.assertNotNull((Object)stream.read());
            }
        });
    }

    @Override
    @Test
    protected void testCreateWithInvalidDataFilePath() {
        Assertions.assertThrows(TerminateToolException.class, () -> {
            try (ObjectStream stream = this.factory.create(new String[]{"-tagset", "u", "-data", this.sampleFileFullPath + "xyz"});){
                POSSample sample = (POSSample)stream.read();
                Assertions.assertNotNull((Object)sample);
            }
        });
    }
}

