/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats.brat;

import java.io.FileFilter;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import opennlp.tools.formats.brat.AbstractBratTest;
import opennlp.tools.formats.brat.AnnotationConfiguration;
import opennlp.tools.formats.brat.BratDocumentStream;
import opennlp.tools.formats.brat.BratNameSampleStream;
import opennlp.tools.namefind.NameSample;
import opennlp.tools.sentdetect.NewlineSentenceDetector;
import opennlp.tools.sentdetect.SentenceDetector;
import opennlp.tools.tokenize.Tokenizer;
import opennlp.tools.tokenize.WhitespaceTokenizer;
import opennlp.tools.util.ObjectStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class BratNameSampleStreamTest
extends AbstractBratTest {
    @Override
    @BeforeEach
    public void setup() throws IOException {
        super.setup();
    }

    @Test
    void readNoOverlap() throws IOException {
        BratNameSampleStream stream = this.createNameSampleWith("-entities.", null);
        int count = 0;
        NameSample sample = (NameSample)stream.read();
        while (sample != null) {
            ++count;
            sample = (NameSample)stream.read();
        }
        Assertions.assertEquals((int)8, (int)count);
    }

    @Test
    void readOverlapFail() {
        Assertions.assertThrows(RuntimeException.class, () -> {
            BratNameSampleStream stream = this.createNameSampleWith("-overlapping", null);
            NameSample sample = (NameSample)stream.read();
            while (sample != null) {
                sample = (NameSample)stream.read();
                Assertions.assertNotNull((Object)sample);
            }
        });
    }

    @Test
    void emptySample() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.createNameSampleWith("overlapping", Collections.emptySet()));
    }

    @Test
    void readOverlapFilter() throws IOException {
        BratNameSampleStream stream = this.createNameSampleWith("overlapping", Collections.singleton("Person"));
        int count = 0;
        NameSample sample = (NameSample)stream.read();
        while (sample != null) {
            ++count;
            sample = (NameSample)stream.read();
        }
        Assertions.assertEquals((int)8, (int)count);
    }

    private BratNameSampleStream createNameSampleWith(String nameContainsFilter, Set<String> nameTypes) throws IOException {
        AnnotationConfiguration config = new AnnotationConfiguration(this.typeToClassMap);
        FileFilter fileFilter = pathname -> pathname.getName().contains(nameContainsFilter);
        BratDocumentStream bratDocumentStream = new BratDocumentStream(config, this.directory, false, fileFilter);
        return new BratNameSampleStream((SentenceDetector)new NewlineSentenceDetector(), (Tokenizer)WhitespaceTokenizer.INSTANCE, (ObjectStream)bratDocumentStream, nameTypes);
    }
}

