/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats.brat;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import opennlp.tools.cmdline.ObjectStreamFactory;
import opennlp.tools.cmdline.StreamFactoryRegistry;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.formats.AbstractSampleStreamFactory;
import opennlp.tools.formats.AbstractSampleStreamFactoryTest;
import opennlp.tools.formats.brat.BratNameSampleStreamFactory;
import opennlp.tools.models.ModelType;
import opennlp.tools.namefind.NameSample;
import opennlp.tools.tokenize.TokenizerModel;
import opennlp.tools.util.DownloadUtil;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.Span;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EmptySource;
import org.junit.jupiter.params.provider.ValueSource;

public class BratNameSampleStreamFactoryTest
extends AbstractSampleStreamFactoryTest<NameSample, BratNameSampleStreamFactory.Parameters> {
    private static final Path OPENNLP_DIR = Paths.get(System.getProperty("OPENNLP_DOWNLOAD_HOME", System.getProperty("user.home")), new String[0]).resolve(".opennlp");
    private static final String TOKENIZER_MODEL_NAME = "opennlp-en-ud-ewt-tokens-1.3-2.5.4.bin";
    private BratNameSampleStreamFactory factory;
    private static String tokFileFullPath;
    private String bratFullPath;
    private String configPath;

    @Override
    protected AbstractSampleStreamFactory<NameSample, BratNameSampleStreamFactory.Parameters> getFactory() {
        return this.factory;
    }

    @Override
    protected String getDataFilePath() {
        return this.bratFullPath;
    }

    @BeforeAll
    static void initEnv() {
        BratNameSampleStreamFactory.registerFactory();
        try {
            DownloadUtil.downloadModel((String)"en", (ModelType)ModelType.TOKENIZER, TokenizerModel.class);
        }
        catch (IOException e) {
            Assertions.fail((String)e.getLocalizedMessage());
        }
        tokFileFullPath = new File(String.valueOf(OPENNLP_DIR) + File.separator + TOKENIZER_MODEL_NAME).getPath();
    }

    @BeforeEach
    void setUp() {
        ObjectStreamFactory f = StreamFactoryRegistry.getFactory(NameSample.class, (String)"brat");
        Assertions.assertInstanceOf(BratNameSampleStreamFactory.class, (Object)f);
        this.factory = (BratNameSampleStreamFactory)f;
        Assertions.assertEquals(BratNameSampleStreamFactory.Parameters.class, (Object)this.factory.getParameters());
        this.bratFullPath = this.getResourceWithoutPrefix("opennlp/tools/formats/brat/").getPath();
        this.configPath = this.getResourceWithoutPrefix("opennlp/tools/formats/brat/brat-ann.conf").getPath();
    }

    @ParameterizedTest
    @ValueSource(strings={"simple", "whitespace"})
    void testCreateWithValidParameter(String tokType) throws IOException {
        try (ObjectStream stream = this.factory.create(new String[]{"-ruleBasedTokenizer", tokType, "-annotationConfig", this.configPath, "-bratDataDir", this.bratFullPath});){
            NameSample sample = (NameSample)stream.read();
            Assertions.assertNotNull((Object)sample);
            Span[] names = sample.getNames();
            Assertions.assertNotNull((Object)names);
            Assertions.assertEquals((int)1, (int)names.length);
            Assertions.assertEquals((Object)"Name", (Object)names[0].getType());
            Assertions.assertEquals((int)0, (int)names[0].getStart());
            if ("whitespace".equals(tokType)) {
                Assertions.assertEquals((int)2, (int)names[0].getEnd());
            } else {
                Assertions.assertEquals((int)6, (int)names[0].getEnd());
            }
        }
    }

    @ParameterizedTest
    @EmptySource
    @ValueSource(strings={" ", "unknown"})
    void testCreateWithInvalidRBTokenizer(String tokType) {
        Assertions.assertThrows(TerminateToolException.class, () -> {
            try (ObjectStream stream = this.factory.create(new String[]{"-ruleBasedTokenizer", tokType, "-annotationConfig", this.configPath, "-bratDataDir", this.bratFullPath});){
                NameSample sample = (NameSample)stream.read();
                Assertions.assertNotNull((Object)sample);
            }
        });
    }

    @Test
    void testCreateWithMETokenizer() throws IOException {
        try (ObjectStream stream = this.factory.create(new String[]{"-tokenizerModel", tokFileFullPath, "-annotationConfig", this.configPath, "-bratDataDir", this.bratFullPath});){
            NameSample sample = (NameSample)stream.read();
            Assertions.assertNotNull((Object)sample);
        }
    }

    @ParameterizedTest
    @EmptySource
    @ValueSource(strings={" ", "unknown"})
    void testCreateWithInvalidMETokenizer(String path) {
        Assertions.assertThrows(TerminateToolException.class, () -> {
            try (ObjectStream stream = this.factory.create(new String[]{"-tokenizerModel", path, "-annotationConfig", this.configPath, "-bratDataDir", this.bratFullPath});){
                NameSample sample = (NameSample)stream.read();
                Assertions.assertNotNull((Object)sample);
            }
        });
    }

    @Override
    @Test
    protected void testCreateWithInvalidDataFilePath() {
        Assertions.assertThrows(TerminateToolException.class, () -> {
            try (ObjectStream stream = this.factory.create(new String[]{"-ruleBasedTokenizer", "whitespace", "-annotationConfig", this.configPath, "-bratDataDir", this.bratFullPath + "xyz"});){
                NameSample sample = (NameSample)stream.read();
                Assertions.assertNotNull((Object)sample);
            }
        });
    }
}

