/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats.brat;

import java.io.IOException;
import java.io.InputStream;
import opennlp.tools.formats.brat.AbstractBratTest;
import opennlp.tools.formats.brat.AnnotationConfiguration;
import opennlp.tools.formats.brat.BratAnnotation;
import opennlp.tools.formats.brat.BratDocument;
import opennlp.tools.formats.brat.SpanAnnotation;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class BratDocumentTest
extends AbstractBratTest {
    @Override
    @BeforeEach
    public void setup() throws IOException {
        super.setup();
    }

    @Test
    void testDocumentWithEntitiesParsing() throws IOException {
        AnnotationConfiguration config = new AnnotationConfiguration(this.typeToClassMap);
        InputStream txtIn = this.getResourceStream("brat/voa-with-entities.txt");
        InputStream annIn = this.getResourceStream("brat/voa-with-entities.ann");
        BratDocument doc = BratDocument.parseDocument((AnnotationConfiguration)config, (String)"voa-with-entities", (InputStream)txtIn, (InputStream)annIn);
        Assertions.assertEquals((Object)"voa-with-entities", (Object)doc.getId());
        Assertions.assertTrue((boolean)doc.getText().startsWith(" U . S .  President "));
        Assertions.assertTrue((boolean)doc.getText().endsWith("multinational process . \n"));
        Assertions.assertEquals((int)18, (int)doc.getAnnotations().size());
        BratAnnotation annotation = doc.getAnnotation("T2");
        this.checkNote(annotation, "Barack Obama", "President Obama was the 44th U.S. president");
        annotation = doc.getAnnotation("T3");
        this.checkNote(annotation, "South Korea", "The capital of South Korea is Seoul");
    }

    private void checkNote(BratAnnotation annotation, String expectedCoveredText, String expectedNote) {
        Assertions.assertInstanceOf(SpanAnnotation.class, (Object)annotation);
        SpanAnnotation spanAnn = (SpanAnnotation)annotation;
        Assertions.assertEquals((Object)expectedCoveredText, (Object)spanAnn.getCoveredText());
        Assertions.assertEquals((Object)expectedNote, (Object)spanAnn.getNote());
    }

    @Test
    void testSpanWithMultiFragments() throws IOException {
        AnnotationConfiguration config = new AnnotationConfiguration(this.typeToClassMap);
        InputStream txtIn = this.getResourceStream("brat/opennlp-1193.txt");
        InputStream annIn = this.getResourceStream("brat/opennlp-1193.ann");
        BratDocument doc = BratDocument.parseDocument((AnnotationConfiguration)config, (String)"opennlp-1193", (InputStream)txtIn, (InputStream)annIn);
        SpanAnnotation t1 = (SpanAnnotation)doc.getAnnotation("T1");
        Assertions.assertEquals((int)0, (int)t1.getSpans()[0].getStart());
        Assertions.assertEquals((int)7, (int)t1.getSpans()[0].getEnd());
        Assertions.assertEquals((int)8, (int)t1.getSpans()[1].getStart());
        Assertions.assertEquals((int)15, (int)t1.getSpans()[1].getEnd());
        Assertions.assertEquals((int)17, (int)t1.getSpans()[2].getStart());
        Assertions.assertEquals((int)24, (int)t1.getSpans()[2].getEnd());
        SpanAnnotation t2 = (SpanAnnotation)doc.getAnnotation("T2");
        Assertions.assertEquals((int)26, (int)t2.getSpans()[0].getStart());
        Assertions.assertEquals((int)33, (int)t2.getSpans()[0].getEnd());
        Assertions.assertEquals((int)40, (int)t2.getSpans()[1].getStart());
        Assertions.assertEquals((int)47, (int)t2.getSpans()[1].getEnd());
    }
}

