/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats.brat;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import opennlp.tools.formats.brat.AbstractBratTest;
import opennlp.tools.formats.brat.AnnotationConfiguration;
import opennlp.tools.formats.brat.BratDocument;
import opennlp.tools.formats.brat.BratDocumentParser;
import opennlp.tools.namefind.NameSample;
import opennlp.tools.sentdetect.NewlineSentenceDetector;
import opennlp.tools.sentdetect.SentenceDetector;
import opennlp.tools.tokenize.Tokenizer;
import opennlp.tools.tokenize.WhitespaceTokenizer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class BratDocumentParserTest
extends AbstractBratTest {
    @Override
    @BeforeEach
    public void setup() throws IOException {
        super.setup();
    }

    @Test
    void testParse() throws IOException {
        AnnotationConfiguration config = new AnnotationConfiguration(this.typeToClassMap);
        InputStream txtIn = this.getResourceStream("brat/opennlp-1193.txt");
        InputStream annIn = this.getResourceStream("brat/opennlp-1193.ann");
        BratDocument doc = BratDocument.parseDocument((AnnotationConfiguration)config, (String)"opennlp-1193", (InputStream)txtIn, (InputStream)annIn);
        Assertions.assertNotNull((Object)doc);
        BratDocumentParser parser = new BratDocumentParser((SentenceDetector)new NewlineSentenceDetector(), (Tokenizer)WhitespaceTokenizer.INSTANCE);
        List names = parser.parse(doc);
        Assertions.assertEquals((int)3, (int)names.size());
        NameSample sample1 = (NameSample)names.get(0);
        Assertions.assertNotNull((Object)sample1);
        Assertions.assertEquals((int)1, (int)sample1.getNames().length);
        Assertions.assertEquals((int)0, (int)sample1.getNames()[0].getStart());
        Assertions.assertEquals((int)2, (int)sample1.getNames()[0].getEnd());
        NameSample sample2 = (NameSample)names.get(1);
        Assertions.assertNotNull((Object)sample2);
        Assertions.assertEquals((int)1, (int)sample2.getNames().length);
        Assertions.assertEquals((int)0, (int)sample2.getNames()[0].getStart());
        Assertions.assertEquals((int)1, (int)sample2.getNames()[0].getEnd());
        NameSample sample3 = (NameSample)names.get(2);
        Assertions.assertNotNull((Object)sample3);
        Assertions.assertEquals((int)3, (int)sample3.getNames().length);
        Assertions.assertEquals((int)0, (int)sample3.getNames()[0].getStart());
        Assertions.assertEquals((int)1, (int)sample3.getNames()[0].getEnd());
        Assertions.assertEquals((int)1, (int)sample3.getNames()[1].getStart());
        Assertions.assertEquals((int)2, (int)sample3.getNames()[1].getEnd());
        Assertions.assertEquals((int)2, (int)sample3.getNames()[2].getStart());
        Assertions.assertEquals((int)3, (int)sample3.getNames()[2].getEnd());
    }
}

