/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats.brat;

import java.io.IOException;
import java.util.LinkedHashSet;
import opennlp.tools.formats.brat.AbstractBratTest;
import opennlp.tools.formats.brat.AnnotationConfiguration;
import opennlp.tools.formats.brat.AnnotatorNoteAnnotation;
import opennlp.tools.formats.brat.BratAnnotation;
import opennlp.tools.formats.brat.BratAnnotationStream;
import opennlp.tools.formats.brat.RelationAnnotation;
import opennlp.tools.formats.brat.SpanAnnotation;
import opennlp.tools.util.ObjectStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class BratAnnotationStreamTest
extends AbstractBratTest {
    private static final String[] VOA_PERSONS = new String[]{"Obama", "Barack Obama", "Lee Myung - bak"};
    private static final String[] VOA_LOCATIONS = new String[]{"South Korea", "North Korea", "China", "South Korean", "United States", "Pyongyang"};
    private static final String[] VOA_DATES = new String[]{"Wednesday", "Wednesday evening", "Thursday"};

    @Override
    @BeforeEach
    public void setup() throws IOException {
        super.setup();
    }

    @Test
    void testParsingEntities() throws IOException {
        AnnotationConfiguration annConfig = new AnnotationConfiguration(this.typeToClassMap);
        ObjectStream<BratAnnotation> annStream = this.creatBratAnnotationStream(annConfig, "brat/voa-with-entities.ann");
        Assertions.assertNotNull(annStream);
        this.validateBratAnnotationStream(annStream, 5, 10, 3, 0, 2, 0);
    }

    @Test
    void testParsingRelations() throws IOException {
        this.typeToClassMap.put("Related", "Relation");
        AnnotationConfiguration annConfig = new AnnotationConfiguration(this.typeToClassMap);
        ObjectStream<BratAnnotation> annStream = this.creatBratAnnotationStream(annConfig, "brat/voa-with-relations.ann");
        Assertions.assertNotNull(annStream);
        this.validateBratAnnotationStream(annStream, 5, 10, 3, 0, 0, 7);
    }

    private ObjectStream<BratAnnotation> creatBratAnnotationStream(AnnotationConfiguration conf, String file) {
        return new BratAnnotationStream(conf, "testing", this.getResourceStream(file));
    }

    private void validateBratAnnotationStream(ObjectStream<BratAnnotation> annStream, int expectPersons, int expectLocations, int expectDates, int expectOrganizations, int expectAnnotations, int expectRelations) throws IOException {
        BratAnnotation ann;
        int dates = 0;
        int persons = 0;
        int relations = 0;
        int locations = 0;
        int annotations = 0;
        int organizations = 0;
        LinkedHashSet<String> annotatedDates = new LinkedHashSet<String>();
        LinkedHashSet<String> annotatedPersons = new LinkedHashSet<String>();
        LinkedHashSet<String> annotatedLocations = new LinkedHashSet<String>();
        block16: while ((ann = (BratAnnotation)annStream.read()) != null) {
            Assertions.assertNotNull((Object)ann);
            String type = ann.getType();
            Assertions.assertNotNull((Object)type);
            String coveredText = null;
            RelationAnnotation rAnnotation = null;
            AnnotatorNoteAnnotation aAnnotation = null;
            if (ann instanceof SpanAnnotation) {
                SpanAnnotation sAnnotation = (SpanAnnotation)ann;
                coveredText = sAnnotation.getCoveredText();
                Assertions.assertNotNull((Object)coveredText);
            } else if (ann instanceof RelationAnnotation) {
                rAnnotation = (RelationAnnotation)ann;
            } else if (ann instanceof AnnotatorNoteAnnotation) {
                aAnnotation = (AnnotatorNoteAnnotation)ann;
            } else {
                Assertions.fail((String)("Found object of invalid class for '" + type + "' type!"));
            }
            switch (type) {
                case "Person": {
                    ++persons;
                    annotatedPersons.add(coveredText);
                    continue block16;
                }
                case "Location": {
                    ++locations;
                    annotatedLocations.add(coveredText);
                    continue block16;
                }
                case "Date": {
                    ++dates;
                    annotatedDates.add(coveredText);
                    continue block16;
                }
                case "Organization": {
                    ++organizations;
                    continue block16;
                }
                case "Related": {
                    ++relations;
                    Assertions.assertNotNull((Object)rAnnotation);
                    continue block16;
                }
                case "#AnnotationNote": {
                    ++annotations;
                    Assertions.assertNotNull((Object)aAnnotation);
                    continue block16;
                }
            }
            Assertions.fail((String)"Found an unsupported BRAT type!");
        }
        Assertions.assertEquals((int)expectDates, (int)dates);
        Assertions.assertEquals((int)expectPersons, (int)persons);
        Assertions.assertEquals((int)expectLocations, (int)locations);
        Assertions.assertEquals((int)expectAnnotations, (int)annotations);
        Assertions.assertEquals((int)expectOrganizations, (int)organizations);
        Assertions.assertEquals((int)expectOrganizations, (int)organizations);
        Assertions.assertEquals((int)expectRelations, (int)relations);
        Assertions.assertArrayEquals((Object[])VOA_DATES, (Object[])annotatedDates.toArray());
        Assertions.assertArrayEquals((Object[])VOA_PERSONS, (Object[])annotatedPersons.toArray());
        Assertions.assertArrayEquals((Object[])VOA_LOCATIONS, (Object[])annotatedLocations.toArray());
    }
}

