/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats.ad;

import java.io.File;
import java.io.IOException;
import opennlp.tools.formats.ad.ADTokenSampleStreamFactory;
import opennlp.tools.formats.ad.AbstractADSampleStreamTest;
import opennlp.tools.tokenize.TokenSample;
import opennlp.tools.util.ObjectStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ADTokenSampleStreamTest
extends AbstractADSampleStreamTest<TokenSample> {
    @Test
    void testSimpleCount() {
        Assertions.assertEquals((int)8, (int)this.samples.size());
    }

    @Test
    void testSentences() {
        Assertions.assertTrue((boolean)((TokenSample)this.samples.get(5)).getText().contains("ofereceu-me"));
    }

    @Override
    @BeforeEach
    void setup() throws IOException {
        super.setup();
        ADTokenSampleStreamFactory factory = new ADTokenSampleStreamFactory(ADTokenSampleStreamFactory.Parameters.class);
        File data = new File(this.getResourceWithoutPrefix("opennlp/tools/formats/ad/ad.sample").getFile());
        Assertions.assertNotNull((Object)data);
        File dict = new File(this.getResourceWithoutPrefix("opennlp/tools/tokenize/latin-detokenizer.xml").getFile());
        Assertions.assertNotNull((Object)dict);
        String[] args = new String[]{"-data", data.getCanonicalPath(), "-encoding", "UTF-8", "-lang", "por", "-detokenizer", dict.getCanonicalPath()};
        try (ObjectStream tokenSampleStream = factory.create(args);){
            TokenSample sample = (TokenSample)tokenSampleStream.read();
            while (sample != null) {
                this.samples.add(sample);
                sample = (TokenSample)tokenSampleStream.read();
            }
        }
    }
}

