/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats.ad;

import java.io.IOException;
import opennlp.tools.cmdline.ObjectStreamFactory;
import opennlp.tools.cmdline.StreamFactoryRegistry;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.formats.AbstractSampleStreamFactory;
import opennlp.tools.formats.AbstractSampleStreamFactoryTest;
import opennlp.tools.formats.ad.ADTokenSampleStreamFactory;
import opennlp.tools.tokenize.TokenSample;
import opennlp.tools.util.ObjectStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class ADTokenSampleStreamFactoryTest
extends AbstractSampleStreamFactoryTest<TokenSample, ADTokenSampleStreamFactory.Parameters> {
    private static final String DETOKENIZER_FILE = "opennlp/tools/tokenize/latin-detokenizer.xml";
    private static final String SAMPLE_01 = "ad.sample";
    private ADTokenSampleStreamFactory factory;
    private String detokFileFullPath;
    private String sampleFileFullPath;

    @Override
    protected AbstractSampleStreamFactory<TokenSample, ADTokenSampleStreamFactory.Parameters> getFactory() {
        return this.factory;
    }

    @Override
    protected String getDataFilePath() {
        return this.sampleFileFullPath;
    }

    @BeforeAll
    static void initEnv() {
        ADTokenSampleStreamFactory.registerFactory();
    }

    @BeforeEach
    void setUp() {
        ObjectStreamFactory f = StreamFactoryRegistry.getFactory(TokenSample.class, (String)"ad");
        Assertions.assertInstanceOf(ADTokenSampleStreamFactory.class, (Object)f);
        this.factory = (ADTokenSampleStreamFactory)f;
        Assertions.assertEquals(ADTokenSampleStreamFactory.Parameters.class, (Object)this.factory.getParameters());
        this.detokFileFullPath = this.getResourceWithoutPrefix(DETOKENIZER_FILE).getPath();
        this.sampleFileFullPath = this.getResourceWithoutPrefix("opennlp/tools/formats/ad/ad.sample").getPath();
    }

    @ParameterizedTest
    @ValueSource(strings={"true", "false"})
    void testCreateWithValidParameter(String includeTitles) throws IOException {
        try (ObjectStream stream = this.factory.create(new String[]{"-splitHyphenatedTokens", includeTitles, "-lang", "por", "-encoding", "UTF-8", "-detokenizer", this.detokFileFullPath, "-data", this.sampleFileFullPath});){
            TokenSample sample = (TokenSample)stream.read();
            Assertions.assertNotNull((Object)sample);
        }
    }

    @Override
    @Test
    protected void testCreateWithInvalidDataFilePath() {
        Assertions.assertThrows(TerminateToolException.class, () -> {
            try (ObjectStream stream = this.factory.create(new String[]{"-splitHyphenatedTokens", "false", "-lang", "por", "-encoding", "UTF-8", "-detokenizer", this.detokFileFullPath, "-data", this.sampleFileFullPath + "xyz"});){
                TokenSample sample = (TokenSample)stream.read();
                Assertions.assertNotNull((Object)sample);
            }
        });
    }
}

