/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats.ad;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import opennlp.tools.formats.ad.ADSentenceSampleStream;
import opennlp.tools.formats.ad.AbstractADSampleStreamTest;
import opennlp.tools.sentdetect.SentenceSample;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.PlainTextByLineStream;
import opennlp.tools.util.Span;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ADSentenceSampleStreamTest
extends AbstractADSampleStreamTest<SentenceSample> {
    @Override
    @BeforeEach
    void setup() throws IOException {
        super.setup();
        try (ADSentenceSampleStream stream = new ADSentenceSampleStream((ObjectStream)new PlainTextByLineStream(this.in, StandardCharsets.UTF_8), true);){
            SentenceSample sample;
            while ((sample = stream.read()) != null) {
                this.samples.add(sample);
            }
            Assertions.assertFalse((boolean)this.samples.isEmpty());
        }
    }

    @Test
    void testSimpleCount() {
        Assertions.assertEquals((int)5, (int)this.samples.size());
    }

    @Test
    void testSentences() {
        Assertions.assertNotNull((Object)((SentenceSample)this.samples.get(0)).getDocument());
        Assertions.assertEquals((int)3, (int)((SentenceSample)this.samples.get(0)).getSentences().length);
        Assertions.assertEquals((Object)new Span(0, 119), (Object)((SentenceSample)this.samples.get(0)).getSentences()[0]);
        Assertions.assertEquals((Object)new Span(120, 180), (Object)((SentenceSample)this.samples.get(0)).getSentences()[1]);
    }
}

